/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * lined.h --- declarations for line editor
 * (duz 08Jun93)
 */

/* Simple input of one line only: initialize the members string and max_length
   and all others with 0, then call lined().
   For luxury: before first call to lined() initialize history and
   history_max with a static or malloc()-ed memory area, all others with 0.
   Then don't touch the components between further calls to lined()
*/

struct lined
{
  char *string;			/* where to place the result */
  int max_length;		/* maximum chars to input */
  char *history;		/* where the history is kept */
  int history_max;		/* size of history area */
  int (*complete)		/* called on tab key for completion */
    (char *in,			/* string typed so far */
     char *out,			/* possible completion */
     int display);		/* flag: display alternatives */
  void (**executes) (int);	/* NULL or list of functions bound to keys */
  int length;			/* output: how many chars actually typed */
  char overtype, caps, hidden;	/* flags */
  /* these are for internal use only: */
  int cursor,			/* position in the string */
  history_length,		/* how much history is available */
  history_read,			/* when using arrow up and down: */
  history_write;		/* where you are in that mass of strings. */
};

int lined (struct lined *l, char *dflt);
