/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * helpsubr.c --- subroutines for the FORTH online help utilities.
 * (duz 13Sep94)
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>

#include "const.h"
#include "options.h"
#include "help.h"


/*
 * Simple error handling: Report and abort.
 */

char *progname;			/* points in argv [0] */

void
fatal (const char *msg, ...)
/*
 * quit with error message, formatting like printf()
 */
{
  char buf [0x400];
  va_list v;

  va_start (v, msg);
  vsprintf (buf, msg, v);
  va_end (v);
  fprintf (stderr, "%s: %s.\n", progname, buf);
  exit (1);
}

void
sys_error (void)
/*
 * quit with an error message from strerror ()
 */
{
  fatal ("%s", strerror (errno));
}

void
file_errorz (const char *fn)
/*
 * like sys_error when a file name is at hand.
 */
{
  fatal ("File %s: %s", strerror (errno));
}

void *
xalloc (size_t size)
/*
 * like calloc() but dies with erro message when failed.
 */
{
  void *p = malloc (size);
  if (p == NULL)
    sys_error ();
  return p;
}
