#
# Makefile ---	Makefile for Portable Forth Environment.
#
#		Automatically generated, if you change it next time you
#		configure pfe your changes are lost. See
#			src/config/your_system/
#		for files to introduce permanent changes into.
#


#
# WC-OS2V2/basics.mk --	Part of Makefile for PFE, defines variables used
#			with Watcom C on OS/2
#

c	= .c
s	= .asm
o	= .obj
e	= .exe

eo	= /fe=
oo	= /fo=
d	= /d
x	= \\

RM	= rm -f
CP	= copy
MV	= move

TRASH	= *.err *.bak *~ \#*\#


#
# WATCOM/options.mk -	Part of Makefile for PFE, compiler options
#			for WATCOM-C on OS/2, DOS or Windows/NT.
#
# - please set the variable TARGET according to the system you want
#   to build for.
#
# - the Makefile works with dmake in OS/2
#   (dmake - Copyright (c) 1990,1991 by Dennis Vadura, Version 3.80, PL 0),
#   and the way I configured it (default) dmake uses COMSPEC as command line
#   interpreter which in my case is CMD.EXE.
#   If you use gnu-make and/or a unix-like shell as command line interpreter,
#   be prepared to get errors. One possible cause is the neccessary quoting
#   of a possible `\' in $(PREFIX). I must leave it up to you to get it right.
#
# - when you build under DOS, be warned that the command line for the
#   final link step is too long. Replace $(OBJECTS) by *.OBJ.
#

# Targets -- I tried these:

#TARGET	= OS2V2		# 32 bit OS/2 text mode executable
#TARGET	= DOS4G		# 32 bit DOS executable, uses Rational 4GW extender

# I didn't try these but expect them to work:

#TARGET	= ERGO		# 32 bit Ergo DOS extender executables
#TARGET	= PHARLAP	# 32 bit Pharlap DOS extender executables

# These will need some changes in term-wat.c:

 TARGET = WINDOWS	# 32 bit Windows executable, specify /l=WIN386
#TARGET = NT		# 32 bit NT character mode executable
#TARGET = QNX386	# 32 bit QNX executable

# There are more possible targets mentioned in the Watcom manual but
# I haven't heard of them before so I can't tell anything about them.

# Where you store online help files and other stuff.
PREFIX	= "C:"		# define a C-string, path names two `\ inside ""


SYSTEM	= WATCOM
CC	= wcc386
CL	= wcl386
LD	= $(CL)

# /bt=	target OS for wcc386
# /w4	highest possible warning level
# /zq	supress signon messages
# /zc	place const objects and strings in the code segment
# /d	define target as preprocessor symbol
OPTIONS	= /bt=$(TARGET) /w4 /zq /zc /dWC_$(TARGET)

# Recommended in the Watcom manual for best speed:
# /omaxnet
# /5r	optimize for Pentium and use registers for parameter passing
# /zp4	align data on 4 byte boundaries
OPTIM	= /omaxnet /5r /zp4

DEBUG	= /d2

# /l=	target OS for wcl386
# /x	make names case sensitive (maybe useless, seems not to hurt)
LFLAGS	= /l=WIN386 /x

STRIP	= 

LIBS	= 

TERM_O	= term-wat$o
SYS_O	= os2$o


#
# WC-OS2V2/rules.mk ---	Part of Makefile for PFE, rules to build with Watcom C
#

%$o : %$c
		$(CC) $(CFLAGS) $< /fo=$@

%$e : %$o
		$(LD) $(LFLAGS) $< $(LIBS) /fe=$@

%$e : %$c
		$(LD) $(CFLAGS) $(LFLAGS) $< $(LIBS) /fe=$@


#
# default/depend.mk ---	Part of Makefile for PFE: dependencies.
#

# if you want a final optimized version uncomment these lines:
CFLAGS =	$(OPTIONS) $(OPTIM) $(d)PREFIX=$(PREFIX)
LDFLAGS =	$(STRIP) $(LFLAGS)

# if you want a version for C-level debugging uncomment these lines:
#CFLAGS =	$(OPTIONS) $(DEBUG) $(d)PREFIX=$(PREFIX)
#LDFLAGS =	$(DEBUG) $(LFLAGS)


# object files that should be clean ANSI-C:
ANSOBJ =	core$o block$o double$o xception$o facility$o file$o \
		floating$o locals$o memory$o toolkit$o search$o string$o \
		forth-83$o lpf83$o misc$o showhelp$o debug$o dblsub$o \
		support$o dictnry$o vocs$o lined$o term$o

# object files containing environmental dependencies:
ENVOBJ =	main$o $(TERM_O) 4ed$o signals$o sysdep$o $(SYS_O) shell$o \
		yours$o

OBJECTS =	$(ANSOBJ) $(ENVOBJ)

HEADERS =	forth.h config.h virtual.h options.h const.h types.h macros.h \
		support.h preload.h compiler.h dblsub.h term.h help.h lined.h


pfe$e:		$(OBJECTS) version$o
		$(CL) $(LDFLAGS) /fe=pfe $(OBJECTS) version$o $(LIBS)
		wbind pfe -n -s d:\watcom\binw\win386.ext

$(OBJECTS):	$(HEADERS)
$(ENVOBJ):	$(HEADERS) nonansi.h

version$o:	$(OBJECTS)

all:		pfe$e helpidx$e showhelp$e

clean:
		$(RM) pfe$e helpidx$e showhelp$e *$o $(TRASH)

new:		clean all

veryclean:	clean
		$(RM) config.h Makefile

testit:		pfe$e
		( cd ..$(x)test; .$(x)do-tests )


# Rules for the standalone help programs:

helpidx$e:	helpidx$o helpsub$o
		$(CL) $(LDFLAGS) $(eo)helpidx$e helpidx$o helpsub$o

showhelp$e:	showhlps$o helpsub$o
		$(CL) $(LDFLAGS) $(eo)showhelp$e showhlps$o helpsub$o

showhlps$o:	showhelp.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c showhelp.c $(oo)showhlps$o

helpidx$o:	helpidx.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c helpidx.c $(oo)helpidx$o

helpsub$o:	helpsub.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c helpsub.c $(oo)helpsub$o

install:	all
		if [ ! -d $(PFELIB) ]; then mkdir $(PFELIB); fi		;\
		if [ ! -d $(PFEHLP) ]; then mkdir $(PFEHLP); fi		;\
		$(CP) helpidx$e showhelp$e ..$(x)help$(x)*.hlp $(PFEHLP);\
		cd $(PFEHLP)						;\
		helpidx$e -o $(PFEHLP)$(x)index *.hlp
