/*
 *
 * Non-expanded forms of basic type
*/
#include <stdio.h>

#include <ert.H>
#include <string.H>
#include <any.H>
#include <numeric.H>
#include <bool_ref.H>

class STRING;

BOOLEAN_REF::BOOLEAN_REF () {
#ifdef _BOOLEAN_REF_H
	val = false; 
#else
	val = 0; 
#endif
	class_id = _bibt_BOOLEAN_REF_id;		/* defined in ert.H */
	c_object_address = (POINTER) this;
	c_class_name = (POINTER) "BOOLEAN_REF";
}

void BOOLEAN_REF::set_value ( BOOLEAN v) { val = v; }

BOOLEAN BOOLEAN_REF::item () { return val; }

void BOOLEAN_REF::_Copy ( int deep, int sclass, BOOLEAN_REF* v) { 
	val = v->val; 
}

BOOLEAN BOOLEAN_REF::_Equal ( int deep, int sclass, BOOLEAN_REF* v) {
	return v->val == val ? true : false; 
}

STRING* BOOLEAN_REF::out() { 
	STRING *result;

   	result = new STRING;
   	result->make_from_boolean ( val);
	return result;
}

				 	/* BUG! we don't have STD_FILES available */
void BOOLEAN_REF::print ( ANY *s)
{ 
	fprintf ( stderr, "%d", val); 
}
 
BOOLEAN_REF* BOOLEAN_REF::_Clone (
					int deep, int sclass, BOOLEAN_REF *_arg) { 
	BOOLEAN_REF *r = new BOOLEAN_REF; r->val = _arg->val; return r; 
}

BOOLEAN_REF*
_ert_clone_BOOLEAN ( BOOLEAN v)
{
	BOOLEAN_REF *result;
	result = new BOOLEAN_REF;
	result->val = v;
	return result;
}

BOOLEAN_REF*
_ert_clone_BOOLEAN_REF ( BOOLEAN_REF *v)
{
	if ( v) {
		BOOLEAN_REF *result;
		result = new BOOLEAN_REF;
		result->val = v->val;
		return result;
	}

	return ( BOOLEAN_REF *) 0;
}

BOOLEAN_REF *_BOOLEAN_REF_chk(BOOLEAN_REF *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "BOOLEAN_REF", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}


BOOLEAN BOOLEAN_REF::is_equal (BOOLEAN_REF* p1) { 
	return _Equal( 1, 1, p1); 
}

BOOLEAN BOOLEAN_REF::equal (ANY* p1, BOOLEAN_REF* p2) { 
	return (p1)->_Equal ( 0, 1, p2); 
}

void BOOLEAN_REF::copy ( BOOLEAN_REF* p1) { 
	_Copy ( 0, 1, p1); 
}

BOOLEAN_REF* BOOLEAN_REF::clone (BOOLEAN_REF *x) {
	 return _Clone( 0, 1, x); 
}

BOOLEAN_REF* BOOLEAN_REF::_localClone ( int deep, int sclass) { 
	BOOLEAN_REF *r = new BOOLEAN_REF; r->val = val; return r; 
}

BOOLEAN BOOLEAN_REF::deep_equal ( BOOLEAN_REF* p1, BOOLEAN_REF* p2) {
	 return p1->_Equal ( 1, 1, p2); 
}

void BOOLEAN_REF::deep_copy ( BOOLEAN_REF* p1) { 
	_Copy ( 1, 1, p1); 
}

BOOLEAN_REF* BOOLEAN_REF::deep_clone ( BOOLEAN_REF *x) {
	 return _Clone (1,1,x); 
}

BOOLEAN_REF* _bibt_BOOLEAN_BOOLEAN_REF ( BOOLEAN v)
{
	BOOLEAN_REF *result;
	result = new BOOLEAN_REF;
	result->set_value ( v);
	return result;
}

#ifndef _BOOLEAN_REF_H

BOOLEAN BOOLEAN_REF::_INFIX_LEQ ( BOOLEAN_REF* other)
{
	return val < _BOOLEAN_REF_chk ( other, "other")->val ? 
       		_ert_BOOLEAN_Const ( true) : _ert_BOOLEAN_Const ( false);
}

BOOLEAN_REF* BOOLEAN_REF::_INFIX_ADD ( BOOLEAN_REF* other)
{
	BOOLEAN_REF *r = new BOOLEAN_REF; 
	r->val = _BOOLEAN_REF_chk ( other, "other")->val + val;
	return r;
}

BOOLEAN_REF* BOOLEAN_REF::_INFIX_SUB ( BOOLEAN_REF* other)
{
	BOOLEAN_REF *r = new BOOLEAN_REF; 
	r->val = _BOOLEAN_REF_chk ( other, "other")->val - val;
	return r;
}

BOOLEAN_REF* BOOLEAN_REF::_INFIX_MUL ( BOOLEAN_REF* other)
{
	BOOLEAN_REF *r = new BOOLEAN_REF; 
	r->val = _BOOLEAN_REF_chk ( other, "other")->val * val;
	return r;
}

BOOLEAN_REF* BOOLEAN_REF::_INFIX_DIV ( BOOLEAN_REF* other)
{
	BOOLEAN_REF *r = new BOOLEAN_REF; 
	r->val = _BOOLEAN_REF_chk ( other, "other")->val / val;
	return r;
}
#endif /* _BOOLEAN_REF_H */

BOOLEAN BOOLEAN_REF::_Conforms_to ( int other_id)  /* Don't use BOOLEAN */
{
   	if ( class_id == other_id)
      	return true;

#ifdef _BOOLEAN_REF_H
	{
		ANY a;

		return a._Conforms_to ( other_id);
	}
#else
	{
   		NUMERIC n;

   		if ( n.class_id == other_id)
      		return true;

		return n._Conforms_to ( other_id);
	}
#endif
}
