class CORE

creation

   allocate

feature { ANY}

   capacity: INTEGER
      -- size (in bytes) of memory area allocated to `Current'

   space: POINTER
      -- the area allocated

   allocate ( nb_bytes: INTEGER) is
         -- Allocate at least `nb_bytes' of memory
      require
         nb_bytes > 0
      do
         if
            nb_bytes > capacity
         then
            release
            space := c_alloc ( nb_bytes)
		  capacity := nb_bytes;
         end
      ensure
         capacity >= nb_bytes
      end -- allocate

   expand ( newsize: INTEGER) is
         -- increase size of area allocated, preserving contents
         -- only if `newsize' > `capacity'
      local
         tmp_space: CORE
      do
         if 
            newsize > capacity
         then
--          !!tmp_space
            !!tmp_space.allocate ( newsize)
            c_memcpy ( tmp_space.space, space, capacity)
            release
            space := tmp_space.space
            capacity := newsize
         end
      end -- expand

   release is
         -- return memory allocated to `Current' to memory manager
         -- depends upon garbage collection mode: if GC /= manual,
         -- this routine is a no-op
      do
         if
            space /= Void
         then
            core_free ( space)
            space := Void
         end
         capacity := 0
      ensure
         capacity = 0
      end -- release

feature { NONE}

   c_alloc ( n: INTEGER): POINTER is
         -- get `n' bytes of space to store string in,
         -- return (C) pointer to that space, as an integer
   external "C"
   end -- c_alloc

   core_free ( sp: POINTER) is
         -- release any memory allocated to `Current'
   external "C"
   alias "c_free"
   end -- core_free

   c_memcpy ( tgt, src: POINTER; nb: INTEGER) is
   external "C"
   end -- c_memcpy

invariant

   capacity > 0 implies space /= Void

end -- class CORE
