class   ECLEAN
                -- Remove clusters produced by the Eiffel/S
                -- compiler.
-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    make is

        do
            !!io
            !!fs.make
            !!env

            if not fs.has_listperm (".") then
                io.put_string ("Sorry - You dont have list permission%N")
            else
                analyze_commandline

                if ask_for_help then
                    help
                else
                    io.put_string (" Use -h for help%N%N")
                    clean
                end
            end
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    fs           : FILE_SYSTEM
    env          : ENVIRONMENT
    io           : BASIC_IO
    recursively  : BOOLEAN      -- recursive removal?
    ask_for_help : BOOLEAN      -- print help?
    confirm      : BOOLEAN      -- ask before remove?
    list_only    : BOOLEAN      -- show projects without removal?

-----------------------------------------------------------

    analyze_commandline is

        local
            i : INTEGER
            s : STRING
        do
            confirm := true

            from
                i := 1
            until
                i > env.arg_count
            loop
                s := Clone (env.arg_item (i))
                s.to_lower

                if s.is_equal ("-r") then
                    recursively := true
                end
                if s.is_equal ("-l") then
                    list_only := true
                end
                if s.is_equal ("-h") then
                    ask_for_help := true
                end
                if s.is_equal ("-a") then
                    confirm := false
                end
                i := i + 1
            end
        end
-----------------------------------------------------------

    help is

        do
            io.put_string ("  -h : print this help text%N")
            io.put_string ("  -r : process subclusters recursively%N")
            io.put_string ("  -l : list projects only - don't remove them%N")
            io.put_string ("  -a : don't ask before removal%N")
        end
-----------------------------------------------------------

    clean is

        local
            clusters : SORTED_LIST [FSYS_DAT]
            files    : SORTED_LIST [FSYS_DAT]
            it       : ITERATOR
            name     : STRING
            count    : INTEGER
            crnt     : STRING
        do
            crnt := fs.current_cluster

-- Find all ".pdl" files and remove the
-- corresponding projects. Remove error files also.

            files := fs.file_list (".")

            from
                it := files.iterator
            until
                it.finished
            loop
                name  := files.item (it).name
                count := name.count

                if count > 4 and then
                      name.substring (count - 3, count).is_equal (".pdl") then
                    remove_project (name.substring (1, count - 4))
                end

                if name.is_equal ("cc.out") then
                    fs.remove_file (name)
                end
                if name.is_equal ("cc.err") then
                    fs.remove_file (name)
                end
                if name.is_equal ("ecc.err") then
                    fs.remove_file (name)
                end
                if name.is_equal ("etrace") then
                    fs.remove_file (name)
                end
                if name.is_equal ("eiffel.err") then
                    fs.remove_file (name)
                end

                it.forth
            end

-- If recursion is turned on then call clean for
-- every subcluster (if the permissions are ok).

            if recursively then
                clusters := fs.cluster_list (".")

                from
                    it := clusters.iterator
                until
                    it.finished
                loop
                    name := clusters.item (it).name

                    if fs.has_listperm (name) and then
                                            fs.has_modperm (name) then
                        fs.change_cluster (name)
                        clean
                        fs.change_cluster (crnt)
                    end
                    it.forth
                end
            end
        end
-----------------------------------------------------------

    remove_project (project_name : STRING) is

        local
            project    : STRING
            p1, p2, p3 : STRING
            compiled   : BOOLEAN
            remove     : BOOLEAN
        do
            project := fs.absolute_path (project_name)
        
            p1 := Clone (project_name)
            p1.append (".pdb")

            p2 := Clone (project_name)
            p2.append (".p")

            p3 := Clone (project_name)
            p3.append (".op")

            compiled := fs.cluster_exists (p1) or else
                            fs.cluster_exists (p2) or else
                                fs.cluster_exists (p3)

            if compiled then
                if list_only then
                    io.put_string (project)
                    io.put_newline
                else
                    io.put_string (" Remove : ")
                    io.put_string (project)

                    if confirm then
                        io.put_string (" ? (Y/N) : ")
                        io.get_char

                        remove := io.last_char = 'Y' or else 
                                            io.last_char = 'y'
                    else
                        io.put_newline
                        remove := true
                    end

                    if remove then
                        remove_cluster (p1)
                        remove_cluster (p2)
                        remove_cluster (p3)
                    end
                end
            end
        end
-----------------------------------------------------------

    remove_cluster (cluster_name : STRING) is

        local
            files : SORTED_LIST [FSYS_DAT]
            it    : ITERATOR
            name  : STRING
        do
            if fs.cluster_exists (cluster_name) 
                    and then fs.has_modperm (cluster_name) then
                fs.change_cluster (cluster_name)
                files := fs.file_list (".")

                from
                    it := files.iterator
                until
                    it.finished
                loop
                    name := files.item (it).name

                    fs.remove_file (name)
                    it.forth
                end
                fs.change_cluster ("..")
                fs.remove_cluster (cluster_name)
            else
                if fs.cluster_exists (cluster_name) then
                    io.put_string ("  -- Cannot remove cluster %"")
                    io.put_string (cluster_name)
                    io.put_string ("%" - permission denied.%N")
                end
            end
        end
-----------------------------------------------------------

end -- class ECLEAN

