-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
expanded class  REAL

inherit
    REAL_REF
        rename
            make as real_useless
        redefine
            infix "+", infix "-", infix "*", infix "/", infix "^",
            prefix "+", prefix "-", valid_divisor, infix "<", 
            compare, one, zero
    end
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    infix "+" (other : REAL) : REAL is
                        -- Add `other' to Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "-" (other : REAL) : REAL is
                        -- Subtract `other' from Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "*" (other : REAL) : REAL is
                        -- Multiply `other' by Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "/" (other : REAL) : REAL is
                        -- Divide Current by `other'.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "^" (exp : INTEGER) : REAL is
                        -- Raise Current to `exp'-th power.

        external "CWC" -- changed by x_c_cwc
        alias    "RTC9_power"
        end
-----------------------------------------------------------

    prefix "+" : REAL is

        do
            Result := Current
        end
-----------------------------------------------------------

    prefix "-" : REAL is

        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "<" (other : REAL) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    compare (other : REAL) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            if Current < other then
                Result := -1
            else
                if Current > other then
                    Result := 1
                end
            end
        end
-----------------------------------------------------------

    valid_divisor (other : REAL) : BOOLEAN is

        do
            Result := (other /= 0.0)
        end
-----------------------------------------------------------

    one : REAL is

        do
            Result := 1.0
        end
-----------------------------------------------------------

    zero : REAL is

        do
            Result := 0.0
        end
-----------------------------------------------------------

end -- class REAL

