-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   FILE [G]

-----------------------------------------------------------
creation {ANY}
    connect_to
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    connect_to (h : INTEGER) is
                        -- Connect file object to physical file.
        require
            legal_hook : -- `h' must have been obtained from
                         -- a call to `access_file' from class FILE_SYSTEM.
        do
            !!special.make (1)
            hook := h
            rt_connect (hook, special)
        end
-----------------------------------------------------------

    disconnect is
                        -- Disconnect file object from physical file.
        require
            connected : is_connected
        do
            special := Void
            rt_disconnect (hook)
            hook := 0
        end
-----------------------------------------------------------

    is_connected : BOOLEAN is

		do
			Result := (hook > 0)
		end
-----------------------------------------------------------

    put (element : G, index : INTEGER) is

        require
            connected      : is_connected
            positive_index : index >= 1
        do
            special.put (element, 0)
            rt_put (hook, special, index)
        end
-----------------------------------------------------------

    item (index : INTEGER) : G is

        require
            connected      : is_connected
            positive_index : index >= 1
        do
            rt_item (hook, special, index)
            Result := special.item (0)
        end
-----------------------------------------------------------

    count : INTEGER is

        do
            Result := rt_count (hook, special)
        end
-----------------------------------------------------------

    size : INTEGER is   -- For compatiblity only

        do
            Result := count
        end
-----------------------------------------------------------

    put_range (range : ARRAY [G], lower, upper : INTEGER) is
                -- Put the first object in array 'range' 
                -- (i.e. range.item (range.lower)) at position
                -- 'lower' in the current object, the next object
                -- at position 'lower' + 1, etc.
        require
            connected        : is_connected
            positive_index   : lower > 0
            valid_range      : lower <= upper
            range_not_void   : range /= Void
            range_big_enough : upper - lower <= range.upper - range.lower
        do
            rt_put_range (hook, special, range.to_external, lower, upper)
        end
-----------------------------------------------------------

    item_range (lower, upper : INTEGER) : ARRAY [G] is
                -- Build an array with index range [lower, upper]
                -- containing the objects from corresponding
                -- positions in the current object.

        require
			connected      : is_connected
            positive_index : lower > 0
            valid_range    : lower <= upper
        do
            !!Result.make (lower, upper)
            rt_item_range (hook, special, Result.to_external, lower, upper)
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    hook    : INTEGER
    special : ES3_SPEC [G]
-----------------------------------------------------------

    rt_connect (h : INTEGER, sp : ES3_SPEC [G]) is

        external "C" -- changed by x_c_cwc
        alias    "RTC13_connect"
        end
-----------------------------------------------------------

    rt_disconnect (h : INTEGER) is

        external "C" -- changed by x_c_cwc
        alias    "RTC13_disconnect"
        end
-----------------------------------------------------------
       
    rt_put (h : INTEGER, sp : ES3_SPEC [G], index : INTEGER) is

        external "C" -- changed by x_c_cwc
        alias    "RTC13_put"
        end
-----------------------------------------------------------

    rt_item (h : INTEGER, sp : ES3_SPEC [G], index : INTEGER) is

        external "C" -- changed by x_c_cwc
        alias    "RTC13_item"
        end
-----------------------------------------------------------

    rt_count (h : INTEGER, sp : ES3_SPEC [G]) : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC13_count"
        end
-----------------------------------------------------------

    rt_item_range (h : INTEGER, sp : ES3_SPEC [G], rg : POINTER,
                                         lower, upper : INTEGER) is
        external "C" -- changed by x_c_cwc
        alias    "RTC13_item_range"
        end
-----------------------------------------------------------

    rt_put_range (h : INTEGER, sp : ES3_SPEC [G], rg : POINTER,
                                         lower, upper : INTEGER) is
        external "C" -- changed by x_c_cwc
        alias    "RTC13_put_range"
        end
-----------------------------------------------------------

end -- class FILE [G]

