-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------

  
  
class   SORTRACE

inherit
    INTERACT
    end

    ENVIRONMENT
    end

    SYSTEM_TIME
    end

creation
    make

feature

    a1, a2 : ARRAY [STRING] 
    count  : INTEGER 
    sort   : SORTER [STRING] 
    qsort  : QSORTER [STRING] 
    error  : BOOLEAN

-----------------------------------------------------------

    make is

        do
            if not error then
                load_list
            end

            if not error then
                io.put_string ("Sorting ")
                io.put_int (count)
                io.put_string (" elements%N")

                run_qsort
                run_sort

                test_if_equal
            end
 
            io.put_newline

        rescue
            error := true
            retry 
        end
-----------------------------------------------------------

    load_list is

        local
            i    : INTEGER
            f    : TEXTFILE
            path : STRING

        do
            if not error then
                if arg_count > 0 then
                    path := arg_item (1)

                else
                    give_help ("sortrace.hlp")
                    get_a_string ("Name of ASCII file : ")
                    path := the_string
                end

                if not fs.file_exists (path) then
                    io.put_string ("Sorry; file does not exist%N")
                    error := true

                elseif not fs.has_readperm (path) then
                    io.put_string ("Sorry; do not have permission%N")
                    error := true

                else
                    !!f.connect_to (fs.access_file (path, "r", false))
                    count := f.count 

                    from
                        !!a1.make (1, count)  
                        i := 1
                    until
                        i > count
                    loop
                        a1.put (f.item (i), i)
                        i := i + 1
                    end

                    f.abort
                    a2 := clone (a1)
                end
            end

        rescue
            if f /= void then
                f.abort
            end

            error := true
            retry
        end
-----------------------------------------------------------

    run_qsort is

        local
            time : INTEGER

        do
            !!qsort

            time := sysclock
            qsort.sort (a1, 1, count)

            io.put_string ("quicksort : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")
        end
-----------------------------------------------------------

    run_sort is

        local
            time :INTEGER

        do
            !!sort

            time := sysclock
            sort.sort (a2, 1, count)

            io.put_string ("heapsort  : ")
            io.put_int (sysclock - time)
            io.put_string (" ms%N")
        end
-----------------------------------------------------------

    test_if_equal is
        local
            i : INTEGER
        do
            from
                i := 1
            until
                i > count or else not a1.item (i).is_equal (a2.item (i))
            loop
                i := i + 1
            end

            if i <= count then
                io.put_string ("The arrays didn't agree%N")
            end
        end

end -- class SORTRACE

