Chapter 7 
=========

  Restrictions and Deviations 



7.1 Introduction 
================

  The Eiffel/S compiler  translates programs that  are written in the 
  language Eiffel 3.  This chapter describes  the restrictions to and 
  deviations from  the simple  statement just  made. The restrictions 
  are partly arbitrary (e.g.  length of identifiers, literal strings, 
  etc.). In some cases  they were made for  technical reasons and may 
  be removed  in later releases.  With one  exception  all deviations 
  from the language definition [me91] are to be regarded as temporary. 



7.2 Compiler 
============

  The following constants were  chosen arbitrarily but generously. If 
  it should turn out  that some of them  are too restrictive they may 
  be changed in later releases. 


         maximal length of an identifier : 64 characters 

         maximal length of a numerical constant : 64 characters 

         maximal length of a literal string : 512 characters 

         maximal length of a literal bit constant : 512 characters 

         maximal number of classes per program : 8191 

         maximal number of features per program : 262143 


  
7.3 Release dependent deviations from Eiffel 3 
==============================================

  The following deviations from the  language definition apply to the 
  current release. They may be eliminated in later releases: 


* The old expression in  postconditions is not supported. Expressions 
  containing old will be parsed but no C code will be produced. 

* The  strip expression  is not  supported.  The parser  rejects such 
  expressions. 

* recursive Manifest arrays are  not  supported. The  parser  rejects 
  recursive manifest arrays. 

* One cannot use expanded types (other than the basic types) or the 
  POINTER type as actual generic parameter.

* A default rescue clause is not supported. 



7.4 Other deviations 
====================

  The  following  deviations  from Eiffel  3  are  not  for technical 
  reasons.    Rather   we   introduced   them   after   very  careful 
  consideration. 

* The creation procedure of the root class may not have arguments. 



7.5 Libraries 
=============

  The Eiffel/S  basic libraries differ  in several  points from those 
  described    in [me91]  .  Although   we   are  convinced   that  a 
  standardization  of  these libraries  is  absolutely  necessary, we 
  nevertheless found ourselves unable  to accept the proposed classes 
  verbatim. You may be assured  that we considered each deviation --- 
  even the smallest --- very carefully. 


  We  are,  however,  convinced  that  there  will  eventually  be  a 
  standardization process that is carried by you, the users. 

    
