 
/* DEFINITIONS */
/*{{{  states*/
%x endoffile

%{
#define MAX_INCLUDE_DEPTH 50
YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
int include_stack_ptr = 0;
%}

/*}}}  */
/*{{{  global includes and variables*/

%{
#include <math.h>
#include <string.h>
#include "xbw.h"
#include "xbwtype.h"
/*{{{F xbwtype.h*/
/*:::F xbwtype.h*/
/*}}}  */

int command_state = 0;
int debug = 1;
int parameter_state = 0;
int bracket_open = 0;
int error_count = 0;
int warning_count = 0;
char command_name[200]="ERROR";


int SCAN_level=0;

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
          if (feof(yyin)){\
            buf[0]=EOF;\
            result=0;\
            }\
          else {\
            if((result=read(fileno(yyin), (char*)buf, max_size )) < 0){\
              buf[0]=EOF;\
              result=0;\
              };\
            };\
 

%}
/*}}}  */

/* PATTERNS */
 
INTEGER           [0-9][0-9]*
CSTRING           [(]["]([A-Za-z0-9@ <>|,._:;!'$%&/()=?*'#+]|"-"|"["|"]")*["][)]
NSTRING           ["]["]|["][ ]["]
DSTRING           [ ][.]
USTRING           [A-Za-z][A-Za-z0-9@/\\]*
NULLPTR           [(]ptr[)]NULL
NPTRSTRING        [(]ptr[)][A-Z]{3}
SPTRSTRING        [(]str[)][A-Z]{3}
IPTRSTRING        [(]int[)][A-Z]{3}
DPTRSTRING        [(]dbl[)][A-Z]{3}
DOUBLE            (([0-9])+)[.](([0-9])+)([Ee0-9]|"-"|"+")?
 
COMMENT           "%".*
 
NUMVARNAME        [#][A-Za-z][A-Za-z0-9]*
STRVARNAME        [$][A-Za-z][A-Za-z0-9]*
NUMPARNAME        [#][0-9][0-9]*
STRPARNAME        [$][0-9][0-9]*

%%
            /* RULES */
[{] {
  /*{{{  */
  if (!IFTHEN_val){
    SCAN_level++;
    };
  /*}}}  */
  }
[}] {
  /*{{{  */
  if (SCAN_level){
    SCAN_level--;
    };
  if (SCAN_level==0){
    IFTHEN_val=1;
    };
  /*}}}  */
  }
if {
  /*{{{  */
  puts("\nIf command ");
  if(!SCAN_level){return(put_lval_if());};
  /*}}}  */
  }
then {
  /*{{{  */
  puts("\nThen command ");
  if (!SCAN_level){return(put_lval_then());};
  /*}}}  */
  }
{DOUBLE}+ {
  /*{{{  */
  { double dd;
    char sstr[99];
    int ii;
    for (ii=0;ii<98;ii++){
      sstr[ii]=yytext[ii];
      switch(sstr[ii]){
        case 0:
        case 13:
        case 10:
        case ' ':
        case ')':
        case ';':
        case '}':
          sstr[ii]=0;
          ii=99;
          break;
        default:
          break;
        };
      };
    dd = atof(sstr);
    if(!SCAN_level){return(put_lval_double(dd));};
    };
  /*}}}  */
  }
{INTEGER}+ {
  /*{{{  */
  { double dd;
    dd = (double)atoi(yytext);
    if (!SCAN_level){return(put_lval_double(dd)); };
    };
  /*}}}  */
  }
{NULLPTR}+ {
  /*{{{  */
  if(!SCAN_level){return(put_lval_nullptr());};
  /*}}}  */
  }
{CSTRING}+ {
  /*{{{  */
  {
    char sstr[200];
    char *ppos;
    int ii;
    strcpy(sstr,(char*)&yytext[2]);
    if ((ppos=strstr(sstr,"\")"))!=NULL){
      *ppos=0;
      };
    for (ii=0;ii<199;ii++){
      if (sstr[ii]=='\''){ sstr[ii]='\"'; };
      if (!sstr[ii]){ break; };
      };
    if(!SCAN_level){return(put_lval_string(sstr));};
    };
  /*}}}  */
  }
{NSTRING}+ {
  /*{{{  */
  {
    char sstr[200];
    strncpy(sstr,(char*)&yytext[1],3);
    sstr[1]=0;
    if (sstr[0]=='"'){ sstr[1]=0;};
    if(!SCAN_level){return(put_lval_string(sstr));};
    };
  /*}}}  */
  }
{USTRING}+ {
  /*{{{  */
  if(put_lval_isvar(yytext)){
    if (!SCAN_level){return(put_lval_var(yytext));};
    }
  else {
    if(!SCAN_level){
      char sstr[200];
      int ii;
      strncpy(sstr,yytext,199);
      for (ii=0;ii<199;ii++){ if (yytext[ii]==' '){sstr[ii]=0;break; };};
      return(put_lval_string(sstr));
      };
    };
  /*}}}  */
  }
{NPTRSTRING}+|{SPTRSTRING}+|{IPTRSTRING}+|{DPTRSTRING}+ {
  /*{{{  */
  if (!SCAN_level){
    char sstr[10];
    char *pstr;
    strncpy(sstr,(char*)&yytext[5],9);
    sstr[9]=0;
    if ((pstr=strchr(sstr,':')) != NULL){
      *pstr=0;
      };
    return(put_lval_pointer(yytext[1],sstr));
    };
  /*}}}  */
  }
{DSTRING}+ {
  /*{{{  */
  if(!SCAN_level){return(put_lval_string("."));};
  /*}}}  */
  }
{NUMVARNAME}+ {
  /*{{{  */
  if(!SCAN_level){return(put_lval_numvar((char*)&yytext[1]));};
  /*}}}  */
  }
{STRVARNAME}+ {
  /*{{{  */
  if (!SCAN_level){return(put_lval_strvar((char*)&yytext[1]));};
  /*}}}  */
  }
{NUMPARNAME}+ {
  /*{{{  */
  if(!SCAN_level){return(put_lval_num_macropar(atoi((char*)&yytext[1])));};
  /*}}}  */
  }
{STRPARNAME}+ {
  /*{{{  */
  if(!SCAN_level){return(put_lval_str_macropar(atoi((char*)&yytext[1])));};
  /*}}}  */
  }
End[(][)]; {
  /*{{{  */
  if(!SCAN_level){return(put_lval_end_command());};
  /*}}}  */
  }
{COMMENT}+
(" "|[\t\n])+
"/*"        { register int c;
              for (;;){
                while(( (c=input()) !=  '*') && c != EOF)
                  ;
                if (c=='*'){
                  while( (c=input())== '*')
                    ;
                  if (c=='/') break;
                  }
                if (c==EOF){
                  fprintf(stderr,"ERROR: EOF %s in comment!\n",command_name);
                  error_count++;
                  break;
                  }
                }
              }
 
 
<<EOF>> {
  /*{{{  */
  return(0);
  /*}}}  */
  }
 
. {
  if(!SCAN_level){return(yytext[0]);};
  }
 
%%
/* USER CODE */


int begin_include(char *macro){
  /*{{{  */
  strcpy(command_name,macro);
  if ( include_stack_ptr >= MAX_INCLUDE_DEPTH )  {
    fprintf( stderr, "Includes nested too deeply" );
    return(0);
    }
  
  include_stack[include_stack_ptr++] = YY_CURRENT_BUFFER;
  /*{{{  */
  {
    int ii;
    char sstr[200];
    for (ii=0;ii<strlen(command_name);ii++){
      if (command_name[ii]=='\\'){ command_name[ii]='/'; };
      };
    if (command_name[0]=='@'){
      strcpy(command_name,(char *)&command_name[1]);
      };
    yyin = fopen(command_name, "r" );
    if (yyin==NULL){
      sprintf(sstr,"%s.mta",command_name);
      yyin = fopen( sstr, "r" );
      if (yyin==NULL){
        sprintf(sstr,"/xw/x/%s.mta",command_name);
        yyin = fopen( sstr, "r" );
        if (yyin==NULL){
          fprintf(stderr,"ERROR: cannot open file %s !\n",command_name);
          error_count++;
          return(0);
          };
        };
      };
    };
  /*}}}  */
  
  yy_switch_to_buffer( yy_create_buffer( yyin, YY_BUF_SIZE ) );
  printf("\nExec macro file: %s ... ",macro);
  return(1);
  /*}}}  */
  };
 
int end_include(void){
  /*{{{  */
  if (--include_stack_ptr < 0 ){
    /* yyterminate(); */
    return(EOF);
    }
  else {
    if (yyin  != NULL){
      if (yyin != stdin){fclose(yyin);};
      yy_switch_to_buffer( include_stack[include_stack_ptr] );
      };
    };
  printf(" done.");
  return(EOF);
  /*}}}  */
  };

int begin_macro(char *macro){
  /*{{{  */
  YY_BUFFER_STATE buffer;
  
  include_stack_ptr=0;
  buffer= yy_create_buffer( yyin, YY_BUF_SIZE );
  
  yy_switch_to_buffer(buffer);
  
  sprintf(buffer->yy_ch_buf,"%s End();",macro);
  yy_current_buffer->yy_n_chars = strlen(buffer->yy_ch_buf);
  yy_current_buffer->yy_buf_pos = buffer->yy_ch_buf;
  yy_load_buffer_state();
  buffer->yy_eof_status = EOF_PENDING;
  yy_did_buffer_switch_on_eof = 1;
  printf("\nExec object action: %s ... ",macro);
  buffer->yy_input_file=yyin=NULL;
  return(1);
  /*}}}  */
  };

 
