
#define SYSV

/*{{{  Copyleft*/

/*
 *
 *      Created: 2.3.1993
 *      H.Maroske
 *      H"ohenweg 32
 *      7760 Radolfzell
 *
 *      Thanks go to
 *
 *      Win Treese
 *      Cambridge Research Lab
 *      Digital Equipment Corporation
 *      treese@crl.dec.com
 *
 *      $Source: /trx/u2/treese/Src/Xdir.rel/RCS/xdir.c,v $
 *
 *          COPYRIGHT 1990
 *        DIGITAL EQUIPMENT CORPORATION
 *         MAYNARD, MASSACHUSETTS
 *        ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE
 * FOR ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED
 * WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Digital Equipment Corporation not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 *      Modified: 4 Dec 91 - Paul King (king@cs.uq.oz.au)
 */

/*}}}  */
/*{{{  Includes*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <dirent.h>

/*}}}  */

#define INVERT '!'
char *XbWFTb_PckTxt(char *);
/*{{{  Globale Variablen*/
 
 int      file_entry_cnt, dir_entry_cnt;
 char    **file_list, **dir_list;
 char    **filelist, **dirlist;

 
 typedef struct{
   char cur_dir[200];
   char dirmask[200];
   int NoDirt;
   int NoBackups;
   int NoUnknown;
   int NENTRIES;
   }
   SETUPS;
 
 SETUPS SETUP = {
   "",
   "",
   0,
   0,
   0,
   200,
   };
 
 
/*}}}  */
int XbWSSy_FindFirstNr=0;
int wild_match(char *string, char *pattern);
 
/*{{{  Search for Directory- and Filenames    * * * * * * * * * * **/
/*{{{  void MakeFullPath(char *root, char *filename, char *pathname){*/
/*{{{  Beschreibung*/
/* Function:    MakeFullPath() creates the full pathname for the given file.
 * Arguments:   filename:       Name of the file in question.
 *              pathname:       Buffer for full name.
 * Returns:     Nothing.
 * Notes:
 */
/*}}}  */
void MakeFullPath(char *root, char *filename, char *pathname){
  strcpy(pathname, root);
  strcat(pathname, "/");
  strcat(pathname, filename);
  }
/*}}}  */
/*{{{  int IsDirectory(char *root, char *path){*/
/*{{{  Beschreibung*/
/* Function:    IsDirectory() tests to see if a pathname is a directory.
 * Arguments:   path:   Pathname of file to test.
 * Returns:     True (1) or False (0).
 * Notes:       False is returned if the directory is not accessible.
 */
/*}}}  */
int IsDirectory(char *root, char *path){
    char            fullpath[MAXPATHLEN];
    struct stat     statbuf;
    if (path == NULL)
        return (0);
    MakeFullPath(root, path, fullpath);
    if (stat(fullpath, &statbuf))       /* some error, report that it is not
                                         * a directory */
        return (0);
    if (statbuf.st_mode & S_IFDIR)
        return (1);
    else
        return (0);
}
/*}}}  */
/*{{{  int IsLink(char *root, char *path){*/
int IsLink(char *root, char *path){
  char            fullpath[MAXPATHLEN];
  struct stat     statbuf;
  if (path == NULL) {return (0);};
  MakeFullPath(root, path, fullpath);
  if (IsDirectory(root,path)){
    return(0);
    }
  else {
    if (lstat(fullpath, &statbuf)){
      return(0);
      };
    if (statbuf.st_mode & S_IFLNK == S_IFLNK){
      return (1);
      }
    else {
      return (0);
      };
    };
  };

/*}}}  */
/*{{{  int IsExecutable(char *root, char *path){*/
int IsExecutable(char *root, char *path){
    char            fullpath[MAXPATHLEN];
    struct stat     statbuf;
    if (path == NULL)
        return (0);
    MakeFullPath(root, path, fullpath);
    if (stat(fullpath, &statbuf))       /* some error, report that it is not
                                         * a directory */
        return (0);
    if (statbuf.st_mode & S_IXUSR)
        return (1);
    else
        return (0);
}
/*}}}  */
/*{{{  static int star(char *string, char *pattern){*/
/* Return nonzero if `string' matches Unix-style wildcard pattern
   `pattern'; zero if not. */
static int star(char *string, char *pattern){
  while (wild_match(string, pattern) == 0)
    if (*++string == '\0')
      return 0;
  return 1;
  }
/*}}}  */
/*{{{  int wild_match(char *string, char *pattern){*/
/*{{{  Beschreibung*/
/* wildmatch.c - Unix-style command line wildcards

   This procedure is in the public domain.

   After that, it is just as if the operating system had expanded the
   arguments, except that they are not sorted.  The program name and all
   arguments that are expanded from wildcards are lowercased.

   Syntax for wildcards:
   *            Matches zero or more of any character (except a '.' at
                the beginning of a name).
   ?            Matches any single character.
   [r3z]        Matches 'r', '3', or 'z'.
   [a-d]        Matches a single character in the range 'a' through 'd'.
   [!a-d]       Matches any single character except a character in the
                range 'a' through 'd'.

   The period between the filename root and its extension need not be
   given explicitly.  Thus, the pattern `a*e' will match 'abacus.exe'
   and 'axyz.e' as well as 'apple'.  Comparisons are not case sensitive.

   The wild_match code was written by Rich Salz, rsalz@bbn.com,
   posted to net.sources in November, 1986.

   The code connecting the two is by Mike Slomin, bellcore!lcuxa!mike2,
   posted to comp.sys.ibm.pc in November, 1988.

   Major performance enhancements and bug fixes, and source cleanup,
   by David MacKenzie, djm@ai.mit.edu. */

/* Shell-style pattern matching for ?, \, [], and * characters.
   I'm putting this replacement in the public domain.

   Written by Rich $alz, mirror!rs, Wed Nov 26 19:03:17 EST 1986. */
/*}}}  */
int wild_match_sub(char *string, char *pattern){
    int             prev;       /* Previous character in character class. */
    int             matched;    /* If 1, character class has been matched. */
    int             reverse;    /* If 1, character class is inverted. */
    for (; *pattern; string++, pattern++)
        switch (*pattern) {
        case '\\':
            /* Literal match with following character; fall through. */
            pattern++;
        default:
            if (*string != *pattern)
                return 0;
            continue;
        case '?':
            /* Match anything. */
            if (*string == '\0')
                return 0;
            continue;
        case '*':
            /* Trailing star matches everything. */
            return *++pattern ? star(string, pattern) : 1;
        case '[':
            /* Check for inverse character class. */
            reverse = pattern[1] == INVERT;
            if (reverse)
                pattern++;
            for (prev = 256, matched = 0; *++pattern && *pattern != ']';
                 prev = *pattern)
                if (*pattern == '-'
                    ? *string <= *++pattern && *string >= prev
                    : *string == *pattern)
                    matched = 1;
            if (matched == reverse)
                return 0;
            continue;
        }
    return *string == '\0';
}

int wild_match(char *string, char *pattern){
  char sstr[200], substr[100];
  int ret;
  strcpy(sstr,XbWFTb_PckTxt(pattern));
  while(strlen(sstr) > 0){
    if (strchr(sstr,' ') != NULL){
      strcpy(substr,sstr);
      strcpy(strchr(substr,' '),"\0");
      ret=wild_match_sub(string, substr);
      if (ret){return(ret);};
      strcpy(sstr,XbWFTb_PckTxt(strchr(sstr,' ')));
      }
    else {
      return(wild_match_sub(string,sstr));
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  SPComp() compares two string pointers for qsort().*/
/* Function:    SPComp() compares two string pointers for qsort().
 * Arguments:   s1, s2: strings to be compared.
 * Returns:     Value of strcmp().
 * Notes:
 */
int SPComp(char **s1, char **s2){
  return (strcmp(*s1, *s2));
  }
/*}}}  */
/*{{{  char *SaveString(char *string){*/
char *SaveString(char *string){
  char           *new;
  new = (char *) malloc(strlen(string) + 1);
  strcpy(new, string);
  return (new);
  }
/*}}}  */
/*{{{  long MakeFileList(*/
long MakeFileList(
    char *dir_name,
    char *mask,
    char ***dir_list,
    char ***file_list){

    DIR            *dirp;
    struct dirent  *dp;
    char          **cur_file, **cur_directory;
    char          **last_file, **last_dir;

    cur_file = filelist;
    cur_directory = dirlist;
    last_file = filelist + file_entry_cnt - 1;
    last_dir = dirlist + dir_entry_cnt - 1;

    dirp = opendir(dir_name);
    if (dirp == NULL) {
        *file_list = filelist;
        *file_list[0]="";
        *dir_list = dirlist;
        *dir_list[0]="..";
        return (0);
    }
    /* process any events to ensure cursor is set to wait_cursor */
    /*
     * don't do this inside the following loop because this procedure could
     * be re-entered if the user presses (e.g.) rescan
     */

    for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp)) {
        /* skip over '.' (current dir) */
        if (!strcmp(dp->d_name, "."))
            continue;

        if (IsDirectory(dir_name, dp->d_name)) {
            *cur_directory++ = SaveString(dp->d_name);
            if (cur_directory == last_dir) {    /* out of space, make more */
                dirlist = (char **) realloc(dirlist,
                                        2 * dir_entry_cnt * sizeof(char *));
                cur_directory = dirlist + dir_entry_cnt - 1;
                dir_entry_cnt = 2 * dir_entry_cnt;
                last_dir = dirlist + dir_entry_cnt - 1;
            }
        } else {
            /* check if matches regular expression */
            if ((mask == NULL) || (*mask == '\0'))
                mask = "*";
            else if (*mask == '\0')
                mask = "*";
            if (wild_match(dp->d_name, mask) == 0)
                continue;       /* no, do next */
            if (SETUP.NoDirt){
              /*if (GetFileType(dp->d_name) == F_TYPE_O){
                continue;
                };*/
              };
            if (SETUP.NoUnknown){
              /*if (GetFileType(dp->d_name) == F_TYPE_UNKNOWN){
                continue;
                };*/
              };
            if (SETUP.NoBackups){
              /*if (GetFileType(dp->d_name) == F_TYPE_BAK){
                continue;
                };*/
              };
            if (mask[0] == '*' && dp->d_name[0] == '.')
                continue;       /* skip files with leading . */
            *cur_file++ = SaveString(dp->d_name);
            if (cur_file == last_file) {        /* out of space, make more */
                filelist = (char **) realloc(filelist,
                                       2 * file_entry_cnt * sizeof(char *));
                cur_file = filelist + file_entry_cnt - 1;
                file_entry_cnt = 2 * file_entry_cnt;
                last_file = filelist + file_entry_cnt - 1;
            }
        }
    }
    *cur_file = NULL;
    *cur_directory = NULL;
    {
      if (cur_file != filelist) {
        qsort(filelist, cur_file - filelist, sizeof(char *), SPComp);
        };
      if (cur_directory != dirlist) {
        qsort(dirlist, cur_directory - dirlist, sizeof(char *), SPComp);
        };
      *file_list = filelist;
      *dir_list = dirlist;
      };
    *file_list = filelist;
    *dir_list = dirlist;
    closedir(dirp);
    return 1;
}

/*}}}  */
/*}}}  */

int XbWSSy_FindFirstInit=0;
char *XbWSSy_FindFirst(char *directory, char *spec){
  XbWSSy_FindFirstNr=0;
  dir_entry_cnt = SETUP.NENTRIES;
  file_entry_cnt = SETUP.NENTRIES;
  if (!XbWSSy_FindFirstInit){
    filelist = (char **) calloc(file_entry_cnt, sizeof(char *));
    dirlist = (char **) calloc(dir_entry_cnt, sizeof(char *));
    XbWSSy_FindFirstInit=1;
    };
 
  strcpy(SETUP.dirmask,XbWSSy_ConvertFileName(spec));
  strcpy(SETUP.cur_dir,XbWSSy_ConvertFileName(directory));
 
  if (MakeFileList(SETUP.cur_dir, SETUP.dirmask, &dir_list, &file_list) == 0){
    printf("No files in directory?");
    return(NULL);
    };
  XbWSSy_FindFirstNr=0;
  return((char*)filelist[XbWSSy_FindFirstNr]);
  };

char *XbWSSy_FindNext(void){
  XbWSSy_FindFirstNr++;
  if (XbWSSy_FindFirstNr >= SETUP.NENTRIES){return("...");};
  return((char*)filelist[XbWSSy_FindFirstNr]);
  };

/*{{{F ../xdesktop/desktop.c*/
/*:::F ../xdesktop/desktop.c*/
/*}}}  */

 
