
/*==========================================================================
cc -o megawin Megawin.c # UNIX Section
megawin  15 15 20       # 15 15 30
xbw megawin.mta
exit
                        % C   Section
 
This sample creates 15 Projects with 15 Windows with 30 Objects with
22 VAR-elements each; that makes
 
  15x15 =     225 Windows
 225x30 =    6750 Objects
6750x22 =  148500 VAR-Elements, every single one addressable and editable
============================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

short main(short argc, char *argv[]){
  FILE *fp;
  int MAXWIN,MAXOBJ,MAXPRJ,ii,jj,kk;
  if (argc < 4){ return(1);};
  MAXPRJ = atoi(argv[1]);
  MAXWIN = atoi(argv[2]);
  MAXOBJ = atoi(argv[3]);

  if ((fp = fopen("megawin.mta","wt")) == NULL){ return(1);};
 
  fprintf(fp,"Malloc( %d ); \n",500+(MAXWIN*(2+(MAXOBJ+MAXPRJ)/5)+20)*MAXPRJ);
 
  for (kk=1;kk<=MAXPRJ;kk++){
 
    fprintf(fp,"@xbwstart( (\"megawin%d\") (\"color\") );\n",kk);
    fprintf(fp,"wdw( MAIN 10 3 45 35 (\"helpfile.inf\") 1 StandardWDW );\n");
 
    fprintf(fp,"o( MAIN00 S .  0 0 20 1 Extra 0);\n");
    fprintf(fp,"o( MAINE0 S . 24 0 20 1 Extra 0);\n");
    fprintf(fp,"o( MAINE1 S .  0 2 20 1 Extra 0);\n");
    fprintf(fp,"o( MAINE2 S . 0 13 20 1 Extra 0);\n");

    for (ii=1;ii<=MAXPRJ;ii++){
      int iii = ii-1;
      fprintf(fp,"o( MAINP%02d S . %d %d 4 1 Secure 0);\n",ii,(iii-(iii/10)*10)*4,(iii/10)+3);
      };
 
    for (ii=1;ii<=MAXOBJ;ii++){
      int iii = ii-1;
      fprintf(fp,"o( MAIN%02d S . %d %d 4 1 Extra 0);\n",ii,(iii-(iii/10)*10)*4,(iii/10)+14);
      };

    fprintf(fp,"bg( MAIN00 . (\"Project %d\") ); cn( rbK (\"MoveWdw();\") ); eg();\n",kk);
    fprintf(fp,"bg( MAINE0 . (\"Exit System\") ); cn( rbK (\"@xbwstop();\") ); eg();\n");
    fprintf(fp,"bg( MAINE1 . (\"Projects:\") ); eg();\n");
    fprintf(fp,"bg( MAINE2 . (\"Windows:\") ); eg();\n");

    for (ii=1;ii<=MAXPRJ;ii++){
      fprintf(fp,"bg( MAINP%02d . (\"%d\") ); cn( raK (\"SelectPrj( ('megawin%d') MAIN );\") ); eg();\n",ii,ii,ii);
      };

    for (ii=1;ii<=MAXOBJ;ii++){
      if (ii > MAXWIN){
        fprintf(fp,"bg( MAIN%02d . (\"---\") ); eg();\n",ii);
        }
      else {
        fprintf(fp,"bg( MAIN%02d . (\"%d\") ); cn( aW ME%02d ); eg();\n",ii,ii,ii);
        };
      };

    for (jj=1;jj<=MAXWIN;jj++){
      fprintf(fp,"\n\n");
      fprintf(fp,"Message( (\"processing window %d\") );\n",jj);
      fprintf(fp,"wdw( ME%02d 5 10 45 20 (\"helpfile.inf\") 1 StandardWDW );\n",jj);
 
      fprintf(fp,"o( ME%02d00 S . 0 0 20 1 Extra 0);\n",jj);
      fprintf(fp,"o( ME%02dMM S . 0 1  5 1 Extra 0);\n",jj);
      fprintf(fp,"o( ME%02dM1 S . 0 9 20 1 Extra 0);\n",jj);

      fprintf(fp,"o( ME%02dA0 S S 0 2 30 1 Standard 0);\n",jj);
      fprintf(fp,"o( ME%02dA1 I I 0 3  8 1 Standard 0);\n",jj);
      fprintf(fp,"o( ME%02dA2 D D 0 4 20 1 Standard 0);\n",jj);

      for (ii=1;ii<=MAXOBJ;ii++){
        int iii=ii-1;
        fprintf(fp,"o( ME%02d%02d S . %d %d 4 1 Extra 0);\n",jj,ii,(iii-(iii/10)*10)*4,(iii/10)+10);
        };
 
      fprintf(fp,"bg( ME%02d00 . (\"Window %d\") ); cn( rbK (\"MoveWdw();\") ); eg();\n",jj,jj);
      fprintf(fp,"bg( ME%02dMM . MAIN ); cn( aW MAIN ); eg();\n",jj);
      fprintf(fp,"bg( ME%02dM1 . (\"Windows:\") ); eg();\n",jj);
 
      fprintf(fp,"bg( ME%02dA0 . (\"Teststring %d\") ); eg();\n",jj,jj);
      fprintf(fp,"bg( ME%02dA1 . %d ); eg();\n",jj,jj);
      fprintf(fp,"bg( ME%02dA2 .  1.0 );",jj);
      fprintf(fp," ff( (\"%s\") . 1.0 ); eg();\n","%%7.3f");

      for (ii=1;ii<=MAXOBJ;ii++){
        if (ii > MAXWIN){
          fprintf(fp,"bg( ME%02d%02d . (\"---\") ); cn( aW ME%02d ); eg();\n",jj,ii,ii);
          }
        else {
          fprintf(fp,"bg( ME%02d%02d . (\"%d\") ); cn( aW ME%02d ); eg();\n",jj,ii,ii,ii);
          };
        };
      };

    fprintf(fp,"RedrawON(); AutoCloseOFF();\n");
    fprintf(fp,"SelectWdw(MAIN);\n");
    };

  fprintf(fp,"WriteFile( (\"Megawin.prj\") );\n");
  fprintf(fp,"IconAllWdw();\n");
  fprintf(fp,"SelectWdw(MAIN);\n");
  fprintf(fp,"End();\n");
  fclose(fp);
  return(0);
  };
