/************************************************/
/*                                              */
/*    Visual X windows Programming Interface    */
/*    ======================================    */
/*                                              */
/*      Copyright (C) 1994  by  Yong Chen       */
/*                                              */
/************************************************/

/* application C source code */

/* include part */

/* X11 and Motif includes part */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <Xm/Frame.h>
#include <X11/Shell.h>

/* application's include part */



/* global definition part */

/* Defines object's Global Access Array */
typedef struct {
	Widget bitmap;
	Widget BulletinBoard1;
	Widget Separator1;
	Widget Label2;
	Widget Text1;
	Widget Separator2;
	Widget exit;
	Widget Text2;
	Widget Label4;
	Widget Frame1;
	Widget picture;
} _GAArray;
static _GAArray vxpOBJ;

/* application's global definitions */



/*
 *main()
*/
void
main(int argc, char **argv)
{
	/* variable & prototype declaration */
	XtAppContext app_context;
	void vxpInitial();
	Widget bitmap;
	Widget BulletinBoard1;
	Widget Separator1;
	Widget Label2;
	void Label2_help_cb();
	Widget Text1;
	void Text1_activate_cb();
	Widget Separator2;
	Widget exit;
	void exit_activate_cb();
	Widget Text2;
	void Text2_activate_cb();
	Widget Label4;
	Widget Frame1;
	Widget picture;

	/* create topLevel widget, initialize application */
	bitmap = XtVaAppInitialize(&app_context, "Bitmap",
		NULL, 0, &argc, argv, NULL, NULL);
	vxpOBJ.bitmap = bitmap;

	/* widgets creation */

	BulletinBoard1 = XtVaCreateWidget("BulletinBoard1",
		xmBulletinBoardWidgetClass,
		bitmap, NULL);
	XtVaSetValues(BulletinBoard1, XmNx, 161, XmNy, 151,
		XmNwidth, 346, XmNheight, 380,
		NULL );
	vxpOBJ.BulletinBoard1 = BulletinBoard1;

	Separator1 = XtVaCreateWidget("Separator1",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator1, XmNx, 23, XmNy, 171,
		XmNwidth, 299, XmNheight, 19,
		NULL );
	XtManageChild(Separator1);
	vxpOBJ.Separator1 = Separator1;

	Label2 = XtVaCreateWidget("Label2",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label2, XmNx, 34, XmNy, 212,
		XmNwidth, 87, XmNheight, 28,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Change Color", 13,
		XtVaTypedArg, XmNalignment, XmRString,
		"XmALIGNMENT_END", 16,
		NULL );
	XtAddCallback(Label2, XmNhelpCallback,
		Label2_help_cb, (XtPointer) NULL);
	XtManageChild(Label2);
	vxpOBJ.Label2 = Label2;

	Text1 = XtVaCreateWidget("Text1",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text1, XmNx, 145, XmNy, 207,
		XmNwidth, 171, XmNheight, 35,
		NULL );
	XtAddCallback(Text1, XmNactivateCallback,
		Text1_activate_cb, (XtPointer) NULL);
	XtManageChild(Text1);
	vxpOBJ.Text1 = Text1;

	Separator2 = XtVaCreateWidget("Separator2",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator2, XmNx, 24, XmNy, 311,
		XmNwidth, 298, XmNheight, 19,
		NULL );
	XtManageChild(Separator2);
	vxpOBJ.Separator2 = Separator2;

	exit = XtVaCreateWidget("exit",
		xmPushButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(exit, XmNx, 116, XmNy, 333,
		XmNwidth, 111, XmNheight, 37,
		XtVaTypedArg, XmNlabelString, XmRString,
		"EXIT", 5,
		NULL );
	XtAddCallback(exit, XmNactivateCallback,
		exit_activate_cb, (XtPointer) NULL);
	XtManageChild(exit);
	vxpOBJ.exit = exit;

	Text2 = XtVaCreateWidget("Text2",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text2, XmNx, 145, XmNy, 266,
		XmNwidth, 171, XmNheight, 35,
		NULL );
	XtAddCallback(Text2, XmNactivateCallback,
		Text2_activate_cb, (XtPointer) NULL);
	XtManageChild(Text2);
	vxpOBJ.Text2 = Text2;

	Label4 = XtVaCreateWidget("Label4",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label4, XmNx, 28, XmNy, 271,
		XmNwidth, 92, XmNheight, 27,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Change Picture", 15,
		XtVaTypedArg, XmNalignment, XmRString,
		"XmALIGNMENT_END", 16,
		NULL );
	XtManageChild(Label4);
	vxpOBJ.Label4 = Label4;

	Frame1 = XtVaCreateWidget("Frame1",
		xmFrameWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Frame1, XmNx, 75, XmNy, 13,
		XmNwidth, 203, XmNheight, 149,
		NULL );
	vxpOBJ.Frame1 = Frame1;

	picture = XtVaCreateWidget("picture",
		xmDrawnButtonWidgetClass,
		Frame1, NULL);
	XtVaSetValues(picture, XmNx, 2, XmNy, 2,
		XmNwidth, 199, XmNheight, 145,
		XtVaTypedArg, XmNlabelType, XmRString,
		"XmPIXMAP", 9,
		XtVaTypedArg, XmNlabelPixmap, XmRString,
		"xlogo64", 8,
		XtVaTypedArg, XmNshadowType, XmRString,
		"XmSHADOW_IN", 12,
		XtVaTypedArg, XmNrecomputeSize, XmRString,
		"False", 6,
		NULL );
	XtManageChild(picture);
	vxpOBJ.picture = picture;

	XtManageChild(Frame1);
	XtManageChild(BulletinBoard1);

	/* Create windows for widgets and map them. */
	XtRealizeWidget(bitmap);
	vxpInitial();
	/* Loop for events. */
	XtAppMainLoop(app_context);
}


void Label2_help_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}



void Text1_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    char *text;

    text = XmTextGetString(w);
    XtVaSetValues(vxpOBJ.picture, XtVaTypedArg, XmNbackground,
        XmRString, text, strlen(text) + 1, NULL);
   XtFree(text);
}



void exit_activate_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
	void exit();
	printf("Good bye, Human!\n");
	exit(0);
}



void Text2_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    char *text;

    text = XmTextGetString(w);
    XtVaSetValues(vxpOBJ.picture, XtVaTypedArg, XmNlabelPixmap,
        XmRString, text, strlen(text) + 1, NULL);
   XtFree(text);
   XmTextSetString(w, "");
}



/* application's initial routine */
void vxpInitial()
{

}


/* application's functions */

