/***************************************************************
 * Change Log:
 * $Log$
 */
#ifndef _typedefs_
#define _typedefs_

#ifdef __cplusplus
extern "C" {
#endif

#define _POSIX_SOURCE 1    /* Disallow all non-POSIX vendor extensions */
#include <stdlib.h>        /* Get size_t declaration */
#include <signal.h>
#include <sys/time.h>


extern const char * const sys_signame[];

typedef enum SCHEDULING_POLICY
{
    SCHED_POLICY_MIN_C,                /* Must be first */
    SCHED_FCFS_C,
    SCHED_ROUND_ROBIN_C,               /* Default sched policy */
    SCHED_PRIORITY_DECAY_C,
    SCHED_POLICY_MAX_C                 /* Must be last */

}                              sched_policy_t;

struct sched_param
{
   sched_policy_t  sched_policy;
   int             sched_priority;
   int             sched_quantum;
};

typedef enum MUTEX_SCHED_PROTOCOL
{
    SCHED_MUTEX_PRIO_MIN_C,        /* Must be first */
    SCHED_MUTEX_NO_PRIO_INHERIT_C, /* Default upon mutex creation */
    SCHED_MUTEX_PRIO_INHERIT_C,
    SCHED_MUTEX_PRIO_PROTECT_C,
    SCHED_MUTEX_PRIO_MAX_C         /* Must be last */

} pthread_protocol_t;

typedef enum DETACHED_STATE
{
   PTHREAD_DETACHED_MIN_C,         /* Must be first */
   PTHREAD_JOINABLE_C,
   PTHREAD_DETACHED_C,              /* Default upon thread creation */
   PTHREAD_DETACHED_MAX_C

} detached_state_t;

/*
 * --  None of Linux standard include files declares a "struct timespec"
 *     data structure.  So, we'll do it here.
 */
struct timespec
{
   long tv_sec;
   long tv_nsec;           /* nanoseconds */
};

#define PTHREAD_MAX_PRIO_C     ((int) 32)
#define PTHREAD_DEFAULT_PRIO_C ((int) 16)
#define PTHREAD_MIN_PRIO_C     ((int) 1)

#define PTHREAD_SCHED_USE_ATTRIBUTES_C ((int) 0)
#define PTHREAD_SCHED_INHERIT_C        ((int) 1)

#undef FALSE
#define FALSE ((int) 0)
#undef TRUE
#define TRUE  ((int) 1)

typedef int                pthread_once_t;
#define PTHREAD_ONCE_INIT  FALSE
#define pthread_once_init  PTHREAD_ONCE_INIT

typedef void * thread_arg_t;
typedef void * arg_t;
typedef void * (*thread_proc_t)(void *);
typedef void   (*exit_proc_t)(void);
typedef void   (*destructor_t)(void *);
typedef void   (*cleanup_t)(void *);
typedef void   (*initroutine_t)(void);

#define THREAD_CANCEL_ENABLED_C    ((int) 0) /* Default upon creation */
#define THREAD_CANCEL_DISABLED_C   ((int) 1)
#define THREAD_CANCEL_DEFERRED_C   ((int) 0) /* Default upon creation */
#define THREAD_CANCEL_ASYNC_C      ((int) 1)

#undef SUCCESS
#define SUCCESS ((int) 0)

#undef FAILURE
#define FAILURE ((int) -1)

#ifdef __cplusplus
}
#endif
#endif
