/*
 * --  utils.h
 */
#ifndef _utils_
#define _utils_
#include <pthread.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void
error_msg( const char *msg );

extern void
print_system_counters( void );

#define THREAD_SUCCESS ((void *)SUCCESS)
#define THREAD_FAILURE ((void *)FAILURE)

#define CHECK(status,msg) \
        { \
           if( status == FAILURE ) \
           { \
               error_msg(msg); \
               pthread_exit( THREAD_FAILURE ); \
           } \
       }

#define print_str(s) \
{  (void) pthread_lock_global_np(); \
   printf("%s\n", (s)); \
   (void) pthread_unlock_global_np(); \
}


#ifdef __cplusplus
}
#endif
#endif
