/* notok2.c (usage: notok2 1-NUM) */

/*
 * This software is in the public domain and may be freely copied and
 * distributed.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY. IN PARTICULAR, THE AUTHORS DO NOT MAKE ANY REPRESENTATION OR
 * WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR
 * ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * A few more incorrect usage tests that are required only if GCC is being used
 * as the C compiler. These test incorrect usage of ereturn2 which is only
 * available with GCC since it uses the GCC extension __typeof__.
 */

#ifndef __GNUC__
#error You must use GCC to compile this file.
#else

#include <stdio.h>
#include <stdlib.h>

#undef EXC_NOPOLLUTE
#include "exc.h"

exc_decl (e1);

int
t2 ()
{
    try
	try ereturn2 (1729); abort (); end
	abort ();
    finally
	abort ();
    end
    abort ();
    /* NOTREACHED */
    return 1729;
}

int
t1 ()
{
    try
	ereturn2 (1729);
	abort ();
    finally
	abort ();
    end
    abort ();
    /* NOTREACHED */
    return 1729;
}

int
main (int argc, char **argv)
{
    int tst, (*t[])() = { t1, t2 };

#define NUM (sizeof t / sizeof *t)

    if (argc != 2 || (tst = atoi (argv[1])) <= 0 || tst > NUM) {
	fprintf (stderr, "Usage: %s 1-%d\n", argv[0], NUM);
	return 1;
    }
    t[tst-1] ();
    abort ();
    return 0;
}

#endif /* __GNUC__ */
