/* notok.c (usage: notok 1-NUM) */

/*
 * This software is in the public domain and may be freely copied and
 * distributed.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY. IN PARTICULAR, THE AUTHORS DO NOT MAKE ANY REPRESENTATION OR
 * WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR
 * ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * Test incorrect usage of EXC. Each test must be run separately since EXC
 * aborts the running program when it detects incorrect usage.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#undef EXC_NO_POLLUTE
#include "exc.h"

exc_decl (e1);
exc_decl (e2);

void
t20 ()
{
    exc_decl (e1);
    exc_decl (e2);
    exc_parent (e1, e2);

    try
	abort ();
    except (e2)
	abort ();
    except (e1)
	abort ();
    end
    abort ();
}

void
t19 ()
{
    volatile int i = 0;
    try
	assert (!i++);
	eraise (e1);
	abort ();
    except (e1)
	continue;
	abort ();
    end
    abort ();
}

void
t18 ()
{
    volatile int i = 0;
    try
	assert (!i++);
    finally
	continue;
	abort ();
    end
    abort ();
}

void
t17 ()
{
    volatile int i = 0;
    try
	assert (!i++);
	continue;
	abort ();
    end
    abort ();
}

void
t16 ()
{
    try
	eraise (e1);
	abort ();
    except (e1)
	break;
	abort ();
    end
    abort ();
}

void
t15 ()
{
    try
    finally
	break;
	abort ();
    end
    abort ();
}

void
t14 ()
{
    try break; abort (); end
    abort ();
}

/*
 * Note that the 3 test cases below are all legal uses of goto - they don't
 * jump outside of the try stmt. However, exc_no_goto_in_try != 0 disallows
 * *all* goto statements within try stmts. Conversely, exc_no_goto_in_try=0
 * allows all goto statements within try stmts (even possibly illegal ones).
 */

void
t13 ()
{
    try
        eraise (e1);
	abort ();
    except (e1)
        goto label;
	abort ();
label:  abort ();
    end
    abort ();
}

void
t12 ()
{
    try
    finally
        goto label;
	abort ();
label:  abort ();
    end
    abort ();
}

void
t11 ()
{
    try
	goto label;
	abort ();
label:  abort ();
    end
    abort ();
}

void
t10 ()
{
    try
	abort ();
    except (e1)
	abort ();
    finally
	abort ();
    end
    abort ();
}

void
t9 ()
{
    try
        try ereturn; abort (); end
	abort ();
    finally
	abort ();
    end
    abort ();
}

void
t8 ()
{
    try
        ereturn;
	abort ();
    finally
        abort ();
    end
    abort ();
}

void
t7 ()
{
    try
	eraise (e1);
	abort ();
    except (e1)
        return;
	abort ();
    end
    abort ();
}

void
t6 ()
{
    try
    finally
        return;
        abort ();
    end
    abort ();
}

void
t5 ()
{
    try return; abort (); end
    abort ();
}

void
t4 ()
{
    try
	eraise (e1);
	abort ();
    except (e2)
	abort ();
    end
    abort ();
}

void
t3 ()
{
    try
        eraise (e1);
        abort ();
    finally
        abort ();
    end
    abort ();
}

void
t2 ()
{
    try eraise (e1); abort (); end
    abort ();
}

void
t1 ()
{
    eraise (e1);
    abort ();
}

int
main (int argc, char **argv)
{
    int tst; 
    void (*t[])() = {
	t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15,
	t16, t17, t18, t19, t20
    };

#define NUM (sizeof t/sizeof *t)

    if (argc != 2 || (tst = atoi (argv[1])) <= 0 || tst > NUM) {
	fprintf (stderr, "Usage: %s 1-%d\n", argv[0], NUM);
	return 1;
    }
    exc_debug = exc_no_goto_in_try = 1;
    t[tst-1] ();
    abort ();
    return 0;
}
