/* config.h */

/*
 * This software is in the public domain and may be freely copied and
 * distributed.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY. IN PARTICULAR, THE AUTHORS DO NOT MAKE ANY REPRESENTATION OR
 * WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR
 * ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * Configuration parameters for EXC. All the parameters below *must* be
 * identical between exc.c and all source files using EXC, else mayhem will
 * surely result. Recompile exc.c and all files using EXC if any of the
 * parameters below are changed.
 */

#ifndef _EXC_CONFIG_H
#define _EXC_CONFIG_H

/*
 * try/eraise are implemented using setjmp/longjmp; therefore, you need to
 * decide whether or not to save/restore the signal mask on each try/eraise
 * if your program actually modifies its signal mask at some point in its
 * execution.
 *
 * Here's what to define:
 *
 *    if (posix) {
 *        #define EXC_USE_SIGSETJMP
 *        if (save/restore sigmask) #define EXC_SAVE_SIGMASK
 *    }
 *    elif (bsd) {
 *        if (save/restore sigmask) #define EXC_USE_SETJMP
 *        else #define EXC_USE__SETJMP // _setjmp
 *    }
 *    else {
 *        #define EXC_USE_SETJMP
 *    }
 *
 * One of EXC_USE_SIGSETJMP, EXC_USE_SETJMP or EXC_USE__SETJMP must be defined.
 * EXC_SAVE_SIGMASK only needs to be defined if EXC_USE_SIGSETJMP is defined
 * and you wish to have try/eraise save/restore the signal mask. Note that on a
 * BSD system #define EXC_USE_SETJMP will save the signal mask, while on a
 * non-BSD system it won't.
 */

/* #define EXC_USE_SIGSETJMP */
/* #define EXC_SAVE_SIGMASK */
/* #define EXC_USE__SETJMP */
#define EXC_USE_SETJMP

/*
 * The maximum number of "except" handlers expected to be declared in a try
 * statement (not the entire program, just any one try statement). It is a
 * checked runtime error to exceed this limit. Using malloc/realloc to
 * dynamically resize seems like overkill, but it would be easy to add.
 */

#define EXC_ARRAY_SZ	16

/*
 * The size of the exception information buffer (in bytes) used by eraise2. The
 * formatted exception information string is always truncated to at most
 * EXC_INFO_SZ characters by using snprintf, a safe sprintf. Using
 * malloc/realloc to dynamically allocate the buffer seems like overkill, but
 * it would be easy to add.
 */

#define EXC_INFO_SZ	64

#endif /* _EXC_CONFIG_H */
