/* misc.c -- Misc functions.
   Copyright (C) 1995 Sandro Sigala - <sansig@freenet.hut.fi> */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include <stdlib.h>

void *
xmalloc (size_t size)
{
    void *ptr;

    if ((ptr = (void *) malloc (size)) == NULL)
    {
	fprintf (stderr, "virtual memory exhausted\n");
	exit (1);
    }

    return (ptr);
}

void *
xrealloc (void *oldp, size_t size)
{
    void *ptr;

    if ((ptr = (void *) realloc (oldp, size)) == NULL)
    {
	fprintf (stderr, "virtual memory exhausted\n");
	exit (1);
    }

    return (ptr);
}

/* misc.c ends here */
