/* $Id: lex.h,v 1.8 1995/08/08 14:42:44 sandro Exp $ */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __LEX_H
#define __LEX_H

#include <stdio.h>

enum {
    NUMBER=256, IDENTIFIER, CHARACTER, STRING, COMMENT, DIRECTIVE,

    KW_AUTO, KW_BREAK, KW_CASE, KW_CHAR, KW_CONST,
    KW_CONTINUE, KW_DEFAULT, KW_DO, KW_DOUBLE, KW_ELSE,
    KW_ENUM, KW_EXTERN, KW_FLOAT, KW_FOR, KW_GOTO, KW_IF,
    KW_INT, KW_LONG, KW_REGISTER, KW_RETURN, KW_SHORT,
    KW_SIGNED, KW_SIZEOF, KW_STATIC, KW_STRUCT, KW_SWITCH,
    KW_TYPEDEF, KW_UNION, KW_UNSIGNED, KW_VOID, KW_VOLATILE,
    KW_WHILE,
    TK_DECREMENT, TK_INCREMENT,
    TK_ADD_ASSIGN, TK_SUB_ASSIGN, TK_MUL_ASSIGN, TK_DIV_ASSIGN,
    TK_MOD_ASSIGN, TK_AND_ASSIGN, TK_OR_ASSIGN, TK_XOR_ASSIGN,
    TK_LEFT_ASSIGN, TK_RIGHT_ASSIGN,
    TK_PTR_OP, TK_EQ_OP, TK_NE_OP, TK_AND_OP, TK_OR_OP, TK_GE_OP,
    TK_LE_OP, TK_LEFT_OP, TK_RIGHT_OP,
    TK_ELLIPSIS,

    LEX_LAST_TOKEN = TK_ELLIPSIS
};

extern char *lex_token_buffer;
extern int lex_lineno;
extern int lex_return_white_spaces;
extern int lex_return_directives;

extern int gettoken (void);
extern void init_lex (void);
extern void done_lex (void);

#endif /* __LEX_H */
