/*
    clients.h : Browsing an Analysis Tool for C-source code;
	        Client-Application-Library headerfile

    Copyright (C) 1993  Eckehard Stolz

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (version 2 of the License).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern short brs_get_all_funct (char *funct, char *file, long *line, 
                            char *module, short *static_flag);

extern short brs_get_all_global_vars (char *funct, char *file, 
                            long *line, char *module, 
                            short *static_flag);

extern short brs_get_funct_calls (char *funct_in, char *file_in, 
                            short sym_once, char *funct, char *file, 
                            long *line, char *module, short *static_flag);

extern short brs_get_var_uses (char *funct_in, char *file_in, short sym_once, 
                            char *var, char *file, long *line, char *module,
                            short *static_flag);

extern short brs_get_funct_called_by (char *funct_in, char *file_in, 
                            short sym_once, char *funct, char *file, 
                            long *line, char *module, short *static_flag);

extern short brs_get_var_used_by (char *var_in, char *file_in, short sym_once, 
                            char *funct, char *file, long *line, 
                            char *module, short *static_flag);

extern short brs_get_includes (char *file_in, char *file, char *inc_file, 
                           short *sys_flag);

extern short brs_get_funct_pos (char *funct_in, char *file_in, char *file, 
                           long *line, long *end_line, char *module);

extern short brs_get_var_pos (char *var_in, char *file_in, char *file, 
                           long *line, char *module);

extern short brs_get_all_types( short type_code, char *type_name, char *file, 
                           long *line);

extern short brs_get_component_use( int type, char *comp_name, char *f_in, 
                         char *file, long *line, char *function);

extern short brs_reinit_browser (char *file, char *err_msg1, char *err_msg2);

extern int brs_get_server_id(char *browser_file);

extern void brs_disconnect_server(void);

extern short brs_connect_server(int server_id);

extern short brs_get_all_files( char *file, char *module);

extern short brs_get_file_dir( char *file_in, char *dir);

extern short brs_get_all_macro( char *macro, char *file, long *line);

extern short brs_what_is( char *item, char *file_in, long line_in,
                   char *file, long *line, char *module );

extern short brs_get_macro_pos (char *macro, char *file_in, char *file, 
                           long *line, char *module);

extern short brs_cut(short type, char *s_file, char *t_id, long t_line, 
              char **def_line, char ** comment, char**body);

extern short brs_get_item_pos( char *item, char *file_in, long line_in,
                        char *file, long *line);
