/*
    cleanup  : Browsing an Analysis Tool for C-source code;
	       Clean up after a system crash

    Copyright (C) 1993  Eckehard Stolz

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (version 2 of the License).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#include "hash.h"
#include "c-bat.h"
#include "clients.h"


struct msgform {
  long mtype;
  char mtext[INTRFACE_BUFSIZE];
};

static struct msgform  Msg; /* message buffer */

static key_t  key = DEFAULT_KEY;
static int  msqid;


main( int argc, char *argv[] )
{ int  server, ret;
  short  code,
         static_flag;
  long   line,
         m_id;
   
  short  cmd, flag;
  int    pid, mtype, cnt, m_char;
  char   buffer[80];

  if ((msqid = msgget (key, 0777)) == -1) 
    { switch( errno )
        { case ENOENT: /* message queue does not exist. Nothing to do */
          case EIDRM:  /* message queue has allready been removed     */
               break;
               
          default:
             printf("Error msgget: (errno %d, %s)\n", errno, strerror(errno) );
             break;
         }
    }
   
  pid = 0;
  cmd = CMD_TERMINATE;
  flag = 0;
      
  for( server = MASTER_ID; server <= MAX_SERVERS;  server++ )
   { printf( "Send Termination request to Server %d\n", server );

     /* we have to do it by hand, because the termination of the last
        server removes the ipc-ressource. This would cause an exit
        by brs_send_cmd
      */
      
     Msg.mtype = server;
     memcpy( Msg.mtext,     &cmd, sizeof(short) );
     memcpy( Msg.mtext + 2, &flag, sizeof(short) );
     memcpy( Msg.mtext + 4, &pid , sizeof(int) );
         
     if( msgsnd( msqid, (struct msgbuf *) &Msg, 8, IPC_NOWAIT ) == -1 )
        break;
      
     sleep(1);
    }

      
  printf("\nRemoving IPC message queue ... ");
   
  if( msgctl( msqid, IPC_RMID, 0 ) == -1 )
    { if( errno == EINVAL )
        printf("allready removed\n", errno, strerror(errno) );
      else
        printf("\nError (errno %d, %s)\n", errno, strerror(errno) );
     }
  else
    printf("succeded !\n" );
   
}
