/* vprintf replacement for Checker.
   Copyright 1993,1994 Tristan Gingold
		  Written September 1993 Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as Tristan Gingold 
   			  8 rue Parmentier
   			  F-91120 PALAISEAU
   			  FRANCE
*/

#include <stdarg.h>
#include "checker.h"
#include "message.h"

extern void check_output_spec(void);

/* File where all error are written. 2 is stderr */
int chkr_out = 2;

/* buffer for chkr_vprintf.  This code is not really beautiful... */
static char buffer[1024];
static int Bindex=0;

/* Some flags. */
#define SIGNED_FL 1		/* The value is signed. */
#define ZERO_JUSTIFY_FL 2	/* Must justify with '0'. */
#define LEFT_JUSTIFY_FL 4	/* Must justify on the left. */
static void add_to_buf(int flags, int base, int width, unsigned int);

/* A simple vprintf(). */
void
chkr_vprintf(const char *message, void **param)
{
 int i;
 int flags;
 int width;
 int len;
  
 Bindex = 0;
 len = strlen(message);
 for(i=0; i < len; i++)
   {
     if (message[i] != '%')
       {
         buffer[Bindex++] = message[i];
         continue;
       }
     i++;
     /* A '%' has been found. */
     if (message[i] == '\0')
       continue;	/* forget the '%' at the end */
     if (message[i] == '%')
       {
         buffer[Bindex++] = '%';	/* `%%' is replaced by `%'. */
         continue;
       }
     flags = 0;
     width = 0;		/* length of the field. */
     /* If '-' follows '%', jutify on the left. */
     if (message[i] == '-')
       {
         flags |= LEFT_JUSTIFY_FL;
         i++;
       }
     /* If '0' follows '%', pads will be inserted. */
     if (message[i] == '0')
       {
         flags |= ZERO_JUSTIFY_FL;
         i++;
       }
     /* Compute the field length. */
     while (message[i] >= '0' && message[i] <= '9')
       {
         width *= 10;
         width += message[i++] - '0';
       }
     switch(message[i])
       {
         case 'd':	/* %d */
           flags |= SIGNED_FL;
           add_to_buf(flags, 10, width, (int)*param);
     	   param++;
           break;
         case 'u':	/* %u */
     	   add_to_buf(flags, 10, width, (unsigned int)*param);
           param++;
           break;
         case 'p':	/* %p */
         case 'x':	/* %x */
           add_to_buf(flags, 16, width, (unsigned int)*param);
           param++;
           break;
         case 'c':	/* %c */
           buffer[Bindex++] = (int)(*param);	/* highly stupid C !! */
           break;
         case 's':	/* %s */
           if ((char*)*param == (char*)0)
             (char*)*param = "(null)";
           if(width == 0)
             {
               strcpy(&buffer[Bindex], (char*)*param);
               Bindex += strlen((char*)*param);
             }
           else
             {
               int l = strlen( (char*)*param );
               strncpy(&buffer[Bindex], (char*)*param, width);
               if (l < width)
                 memset(&buffer[Bindex + l], 
                        flags & ZERO_JUSTIFY_FL ? '0' : ' ', width - l);
               Bindex += width;
     	     }
     	   param++;
     	   break;
         default:
           break;
       }
   }
 buffer[Bindex] = '\0';
 (*___chkr_trap)(buffer);	/* Write the buffer. */
} 	

/* Write P into the buffer according to these args:
 *  If SIGN is true, p is a signed.
 *  BASE if the base.
 *  If WITH_ZERO is true, '0' must be added.
 *  WIDTH is the width of the field.
 */
static void
add_to_buf(int flags, int base, int width, unsigned int p)
{
 static char buf[40];
 int ind=0;
 int i;
 char *digits = "0123456789abcdefghijklmnopqrstuvwxyz";
 
 if (base < 2 || base > 36)
   return;
 
 if((flags & SIGNED_FL) && (signed int)p < 0)
   {
     p = abs((signed int)p);
     buffer[Bindex++] = '-';
   }
 
 if (p == 0)
   buf[ind++] = '0';
 else
   while(p > 0)
     {
       buf[ind++] = digits[p % base];
       p /= base;
     }
 if (width > 0 && !(flags & LEFT_JUSTIFY_FL))
   {
     for(; ind < width; ind++)
       buf[ind]= flags & ZERO_JUSTIFY_FL ? '0': ' ';
   }
 /* reverse copy to buffer */
 for(i = ind -1; i >= 0; i--)
   buffer[Bindex++] = buf[i];
 if (width > 0 && (flags & LEFT_JUSTIFY_FL))
   {
     for(; ind < width; ind++)
       buffer[Bindex++]= flags & ZERO_JUSTIFY_FL ? '0': ' ';
   }
}

/* A simple printf() which use chkr_vprintf(). */
void
chkr_printf(const char *message, ...)
{
 va_list param;
 va_start(param, message);
 chkr_vprintf(message, param);
 va_end(param);
}

/* This function must be called at the beginning of each message. */
void
chkr_header(const char *message, ...)
{
 va_list param;
 va_start(param, message);
 chkr_printf(M_FROM_CHECKER, my_pid_c);
 chkr_vprintf(message, param);
 va_end(param);
}

/* The function which write. */
void
__default_chkr_trap(const char *message)
{
 check_output_spec();
 write(chkr_out, message, strlen(message));
}

void (*___chkr_trap) __P((const char *message)) = __default_chkr_trap;
