/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include "checker.h"
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Generate a unique temporary file name from TEMPLATE.
   The last six characters of TEMPLATE must be "XXXXXX";
   they are replaced with a string that makes the filename unique.  */
char *
DEFUN(mktemp, (template), char *template)
{
  static CONST char letters[]
    = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  CONST char *ptr = letters;
  size_t len;
  struct stat statbuf;

  len = strlen(template);
  if (len < 6 || strcmp(&template[len - 6], "XXXXXX"))
    {
      chkr_errno = EINVAL;
      return NULL;
    }

#if 0
  if (sprintf (&template[len - 5], "%.5u",
  	 (unsigned int) pid % 100000) != 5)
    return NULL;
#else
  strcpy(&template[len - 5], my_pid_c);
#endif

  while (*ptr != '\0') {
    template[len - 6] = *ptr++;
    if (stat(template, &statbuf) < 0 && chkr_errno == ENOENT)  /* TG: __stat */
      return template;
  }

  return NULL;
}
