/* Some systems dependant definitions
   Copyright 1993 Tristan Gingold
		  Written September 1993 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as Tristan Gingold 
   			  8 rue Parmentier
   			  F-91120 PALAISEAU
   			  FRANCE
*/

#define STACK_LIMIT 0xc0000000
#define STACK_DIRECTION -1	/* downward */
#define MIN_ADDRESS	0x60
#define PAGESIZE 0x1000
#define HIGH_ADDR_HEAP 0x7fffffff

#define __KERNEL__
#include <linux/signal.h>
#undef __KERNEL__
#define NSIGNALS _NSIG
#define SIG_HANDLER_T __sighandler_t
/* #define SIG_FRAME_SIZE 23*4	*//* number of bytes for sig handler args */
#define STRUCT_SIG_CONTEXT struct sigcontext_struct
void chkr_sigreturn (STRUCT_SIG_CONTEXT*) __attribute__((noreturn));

#ifdef NEED_MM
#include <sys/mman.h>
#include <linux/mman.h>
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
/* Between MM_LOW and MM_HIGH, the user can't access */
#define MM_LOW		0x80000000
#define MM_HIGH		0xaeffffff
#define MM_HEAP		0x80000000	/* 512 Mb */
#define MM_STACK	0xa4000000	/* 64 Mb */
#define MM_MEM		0xa8000000	/* 64 Mb */
#define MM_SYM		0xac000000	/* 64 Mb */
#define MM_PROT		PROT_READ | PROT_WRITE
#define MM_FLAGS	MAP_FIXED | MAP_PRIVATE | MAP_ANONYMOUS
#define MM_FILE		(-1)
#endif /* NEED_MM */
