/****************************************************************************
** $Id: qbutton.h,v 1.22 1995/06/04 17:28:44 hanord Exp $
**
** Definition of QButton widget class
**
** Author  : Haavard Nord
** Created : 940206
**
** Copyright (C) 1994,1995 by Troll Tech AS.  All rights reserved.
**
*****************************************************************************/

#ifndef QBUTTON_H
#define QBUTTON_H

#include "qwidget.h"


class QButtonGroup;				// button group (qbttngrp.h)


class QButton : public QWidget			// button class
{
    Q_OBJECT
public:
    QButton( QWidget *parent=0, const char *name=0 );
   ~QButton();

    const char *text()		const	{ return btext; }
    void	setText( const char *text );

public:
    bool	isDown()	const	{ return buttonDown; }
    bool	isUp()		const	{ return !buttonDown; }

    bool	isOn()		const	{ return buttonOn; }
    bool	isOff()		const	{ return !buttonOn; }

    void	setAutoResizing( bool );
    bool	autoResizing()	const	{ return autoResize; }
    virtual void adjustSize();

signals:
    void	pressed();
    void	released();
    void	clicked();

protected:
    void	switchOn();
    void	switchOff();

    bool	toggleButton()	const	{ return toggleBt; }
    void	setToggleButton( bool );

    virtual bool hitButton( const QPoint &pos ) const;
    virtual void drawButton( QPainter * );

    void	mousePressEvent( QMouseEvent * );
    void	mouseReleaseEvent( QMouseEvent * );
    void	mouseMoveEvent( QMouseEvent * );
    void	paintEvent( QPaintEvent * );
    void	focusInEvent( QFocusEvent * );
    void	focusOutEvent( QFocusEvent * );

private:
    QString	btext;
    uint	toggleBt	: 1;
    uint	buttonDown	: 1;
    uint	buttonOn	: 1;
    uint	mlbDown		: 1;
    uint	autoResize	: 1;
    QButtonGroup *group;

    friend class QButtonGroup;
};


#endif // QBUTTON_H
