//
// Qt Sample Program: makepic.cpp
//
// This program demonstrates how to create a picture and save it to a file.
// We didn't win any design prize for this car drawing!
//

#include <qpicture.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qapp.h>


void paintCar( QPainter *p )			// paint a car
{
    QPointArray a;
    QBrush brush( yellow, SolidPattern );
    p->setBrush( brush );			// use solid, yellow brush

    a.setPoints( 5, 50,50, 350,50, 450,120, 450,250, 50,250 );
    p->drawPolygon( a );			// draw car body

    QFont f( "courier", 14, QFont::Bold );
    p->setFont( f );

    QColor windowColor( 120, 120, 255 );	// a light blue color
    p->brush().setColor( windowColor );		// fill with this color
    p->drawRect( 80, 80, 250, 70 );		// car window
    p->drawText( 180, 80, 150, 70, AlignCenter, "--  Qt  --\nTroll Tech AS" );

    QPixmap pixmap;
    if ( pixmap.load("flag.bmp") )		// load and draw image
	p->drawPixmap( 100, 90, pixmap );

    p->setBackgroundMode( OpaqueMode );		// set opaque mode
    p->brush().setStyle( DiagCrossPattern );	// diagonal cross fill pattern
    p->brush().setColor( black );		// black fill color
    p->drawEllipse( 90, 210, 80, 80 );		// back wheel
    p->brush().setStyle( CrossPattern );	// cross fill pattern
    p->drawEllipse( 310, 210, 80, 80 );		// front wheel
}


int main( int argc, char **argv )
{
    QApplication app( argc, argv );		// QApplication required!

    QPicture pict;				// our picture
    QPainter paint;				// our painter

    paint.begin( &pict );			// begin painting onto picture
    paintCar( &paint );				// paint!
    paint.end();				// painting done

    char *fileName = "car.pic";			// default picture file name
    if ( argc == 2 )				// use argument as file name
	fileName = argv[1];
    pict.save( fileName );			// save picture
    return 0;
}
