//
// Qt Sample Application: forever.cpp
//
// Draws rectangles forever.
//

#define COLORS 120				// number of colors to use

#include <qlabel.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qapp.h>
#include <stdlib.h>				// defines rand() function

//
// Counter - a widget that displays an unsigned int continously
//

class Counter : public QLabel
{
public:
    Counter( int *number, QWidget *parent=0, const char *name=0 );
protected:
    void timerEvent( QTimerEvent * );
private:
    int * number;				// number to display
};

Counter::Counter( int * c, QWidget *parent, const char * name )
    : QLabel( parent, name )
{
    number = c;
    setNum(0);
    setAutoResizing( TRUE );			// resize to fit the contents
    startTimer( 1000 );				// one second
}

//
// Timer event is called every second and prints out number
//
// not reentrant - Qt doesn't require reentrant event handlers
//
void Counter::timerEvent( QTimerEvent * )
{
    if (number) {
	QString s;
	s.sprintf("%d rectangles/second", *number);
	setText(s);
	*number = 0;
    }
    repaint( TRUE );
}

//
// Forever - a widget that draws rectangles forever
//

class Forever : public QWidget
{
public:
    Forever( QWidget *parent=0, const char *name=0 );
protected:
    void	paintEvent( QPaintEvent * );
    void	timerEvent( QTimerEvent * );
private:
    Counter *	counter;
    int		rectangles;
    QColor	colors[COLORS];
};

//
// Initialize widget
//

Forever::Forever( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    for (int a=0; a<COLORS; a++) {
	colors[a] = QColor( rand()&255,
			    rand()&255,
			    rand()&255 );
    }
    rectangles = 0;
    counter = new Counter( &rectangles );	// counter in its own window
    counter->show();				// show the counter
    startTimer( 0 );				// run continuous timer
}


//
// Paint event, called when widget needs to be painted.
//

void Forever::paintEvent( QPaintEvent * )
{
    QPainter paint;				// painter object
    paint.begin( this );			// start painting in widget
    paint.setWindow( 0, 0, 1024, 1024 );	// define coordinate system
    paint.setPen( NoPen );			// do not draw outline
    paint.setBrush( colors[rand() % COLORS]);	// set random brush color
    QPoint p1( rand()&1023, rand()&1023 );	// p1 = top left
    QPoint p2( rand()&1023, rand()&1023 );	// p2 = bottom right
    QRect r( p1, p2 );
    paint.drawRect( r );			// draw filled rectangle
    paint.end();				// painting finished
}


//
// Timer event is called as often as possible
//

void Forever::timerEvent( QTimerEvent * )
{
    repaint( FALSE );				// repaint, don't erase
    rectangles++;
}

//
// Create and display Forever widget
//

int main( int argc, char **argv )
{
    QApplication a( argc, argv );		// create application object
    Forever always;				// create widget
    always.show();				// show widget
    return a.exec( &always );			// run event loop
}
