#include "matrix.h"

matrix matrix::operator % (const matrix& m) const
{
	#ifdef __RUN_TIME_CHECKING__
	if(this->rowlen() != this->collen()){
		cerr << "invalid matrix size: solve (%) on non-square matrix\n";
		exit(1);
	}
	if(m.rowlen()!=this->rowlen() || m.collen()!=1){
		cerr << "invalid matrix size for B in solve (%), ";
		cerr << "B should be n x 1 matrix.\n";
		exit(1);

	}
	#endif

	long v;
	unsigned long n=this->rowlen();
	matrix A = *this, B = m, C(n,1, 0.0), P;  // C(n,1) because we backsub
											  // on one column only
	A=A.lu(v, P);
	A.backsub(B,C,P,0);
	return C;
}
