#include "matrix.h"

matrix::matrix(void)
{
	this->row = this->col = 0;
	this->mat = NULL;

	#ifdef __DEBUG__
	cerr<<"my no initialization constructor\n";
	#endif
}

matrix::matrix(unsigned long x, unsigned long y)
{
	#ifdef __RUN_TIME_CHECKING__
	if(!(x > 0 && y > 0)){
		cerr << "invalid matrix size\n";
		exit(1);
	}
	#endif

	this->mat = new double[(this->row=x)*(this->col=y)];
	#ifdef __DEBUG__
	cerr<<"regular constructor\n";
	#endif
}

matrix::matrix(unsigned long x, unsigned long y, enum mat_type type)
{
	unsigned long i, j, k, l;

	#ifdef __RUN_TIME_CHECKING__
	if(!(x > 0 && y > 0)){
		cerr << "invalid matrix size\n";
		exit(1);
	}

	if(x!=y){
		cerr << "invalid matrix size: an identity matrix must be square\n";
		exit(1);
	}
	#endif

	k = this->row=x;
	l = this->col=y;

	this->mat = new double[k*l];
	for(i=0;i<k;i++)
		for(j=0;j<l;j++) 
		{
			this->poke(i,j, 0.0);
			if(type==identity && i==j) this->poke(i,j, 1.0);
		}

	#ifdef __DEBUG__
	cerr<<"unity constructor\n";
	#endif
}

matrix::matrix(unsigned long x, unsigned long y, double init)
{
	unsigned long i, j, k, l;

	#ifdef __RUN_TIME_CHECKING__
	if(!(x > 0 && y > 0)){
		cerr << "invalid matrix size\n";
		exit(1);
	}
	#endif

	k = this->row=x;
	l = this->col=y;

	this->mat = new double[k*l];
	for(i=0;i<k;i++) for(j=0;j<l;j++) this->poke(i,j, init);

	#ifdef __DEBUG__
	cerr<<"initialize constructor\n";
	#endif
}

matrix::matrix(unsigned long x, unsigned long y, const char* filename)
{
	this->mat = new double[(this->row=x)*(this->col=y)];
	filename >> *this;

	#ifdef __DEBUG__
	cerr<<"matrix from file constructor\n";
	#endif
}

matrix::~matrix(void)
{
	delete[] this->mat;
	this->row = this->col = 0;

	#ifdef __DEBUG__
	cerr<<"destructor\n";
	#endif
}

matrix::matrix(const matrix & m) // copy constructor
{
	unsigned long i, k;

	this->mat = new double[k=(this->row=m.row)*(this->col=m.col)];
	for(i=0;i<k;i++) this->mat[i] = m.mat[i];

	#ifdef __DEBUG__
	cerr<<"copy constructor\n";
	#endif
}
