//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Select.c,v 0.27 1995/01/20 15:15:01 cncl-adm Exp cncl-adm $
 *
 * Class: CNSelect --- Class interface to select(2) system call
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include <stdlib.h>

#include "Select.h"



/*
 * Constructors
 */
CNSelect::CNSelect()
{
    FD_ZERO(&rdfds);
    FD_ZERO(&wrfds);
    FD_ZERO(&exfds);
}


CNSelect::CNSelect(CNParam *param)
{
    FD_ZERO(&rdfds);
    FD_ZERO(&wrfds);
    FD_ZERO(&exfds);
}


CNSelect::CNSelect(int fd)
{
    FD_ZERO(&rdfds);
    FD_ZERO(&wrfds);
    FD_ZERO(&exfds);

    add_read(fd);
}



/*
 * Call select(2)
 */
bool CNSelect::select()
{
    fd_set rd, wr, ex;
    
    rd = rdfds;
    wr = wrfds;
    ex = exfds;
    
#if CNCL_SYS_HPUX			// brain damage control
    int val = ::select(FD_SETSIZE, (int*)&rd, (int*)&wr, (int*)&ex, 0);
#else
    int val = ::select(FD_SETSIZE, &rd, &wr, &ex, 0);
#endif
    if(val == -1)
	error(NIL, "CNSelect: ", "error in select()");
    return val > 0;
}


bool CNSelect::select(long sec, long usec)
{
    struct timeval timeout;
    
    timeout.tv_sec  = sec;
    timeout.tv_usec = usec;
    
    fd_set rd, wr, ex;
    
    rd = rdfds;
    wr = wrfds;
    ex = exfds;
    
#if CNCL_SYS_HPUX			// brain damage control
    int val = ::select(FD_SETSIZE, (int*)&rd, (int*)&wr, (int*)&ex, &timeout);
#else
    int val = ::select(FD_SETSIZE, &rd, &wr, &ex, &timeout);
#endif
    if(val == -1)
	error(NIL, "CNSelect: ", "error in select()");
    return val > 0;
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSelect::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void CNSelect::dump(ostream &strm) const
{
    strm << "CNSelect { $Revision: 0.27 $ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSelect
static CNClass CNSelect_desc("CNSelect", "$Revision: 0.27 $",
			    CNSelect::new_object);

// "Type" for type checking functions
CNClassDesc CN_SELECT = &CNSelect_desc;






