// -*- C++ -*-

#include <CNCL/ACG.h>
#include <CNCL/Uniform.h>
#include <CNCL/DLREF.h>


main(int argc, char *argv[ ])
{
    CNRNG    * rng = new CNACG;
    CNUniform  zg(0, 1, rng);
    double   * x   = new double[2];
    x[0] = -1; x[1] = 1;
    double     z   = 0.0;

    //
    // Bei folgendem Aufruf sind die m"oglichen x-Werte in einem Array
    // gespeichert:
    //
    CNDLREF    dlref1(x, 2);

    while( !dlref1.end() )
    {
        z = zg();
        //cout << z << " ";
        if( z <= 0.5 )
        {
            dlref1.put( -1 );
        }
        else
        {
            dlref1.put( 1 );
        }
    }

    cout << dlref1;
    
    //
    // Nun werden nur die untere (1.0) und obere (100.0) Grenze 
    // und die Intervalbreite (1.0) angegeben. 
    //
    CNDLREF   dlref2(1.0, 100.0, 1.0);

    CNUniform zg2(1, 101, rng);
    
    while( !dlref2.end() )
    {
        z = long(zg2());
        dlref2.put( z );
    }

    cout << dlref2;
}
