//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: LREG.c,v 0.27 1995/01/20 15:13:27 cncl-adm Exp cncl-adm $
 *
 * Class: CNLREG --- LRE evaluation G(x) (compl. distribution function)
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "LREG.h"



void CNLREG::put (double rvnach)
{

/************************************************************************/
/* Deklaration der internen Variablen                                   */
/************************************************************************/

struct result *presult;                 /* Hilfszeiger Ergebnistabelle  */
register struct result *start,*end;     /* Hilfszeiger Transcountkorretur*/
register int step;                      /* Hilfe Transcountkorretur     */

nrv ++;
CNLRE::rv_sum        += rvnach;
CNLRE::rv_square_sum += rvnach*rvnach;
if (CNLRE::max_value < rvnach) CNLRE::max_value = rvnach; 
else if (CNLRE::min_value > rvnach) CNLRE::min_value = rvnach;  // 03.12.93 (fuss)

if (rvakt <= pr->xlevlim )      /* values lower equal than the current  */
        {                       /* level are not sorted                 */
        verbesser(pfirst,pr,rvakt,rvnach); /* nachbessern der Level */
        }
else
        {
        pr->sortmsize++;
        if (rvnach < pr->xlevlim) /* save transition                    */
                {
                //printf("transcount\n");
                pr->transcount++;
                start = pfirst;
                end = pr;
                while ( (step = (end - start) >> 1) )
                        {
                        presult = start + step ;
                        if ( presult->xlevlim > rvnach)
                                {
                                end = presult;
                                }
                        else
                                {
                                start = presult;
                                }
                        }
                start->transcount--; /* ab da gibt es keine Uebergange mehr */
                }

        /* save the values      */

        sortquickend->rvakt = rvakt;
        sortquickend->rvnach = rvnach;
        sortquickend++;

        if ( pr->sortmsize >= sortfeldgroesse)
                schaufelum();
        }
if ( nrv >= n0) /* nur wenn gegisste Anzahl der benoetigten Werte */
        {
        //printf("go to next level (%f) \n", pr->xlevlim);
        next_level();
        }
rvakt = rvnach;
}

void CNLREG::neusort(struct result *presult)
{

struct sm *end;
register struct sm *dest;
register double neurvakt;

/* sort the sort array   */

/* sort the new valuues        */

if ((sortquickend - sortquick) > 1)
        quicksort(sortquick,sortquickend-1);

/* Sortierte Werte mit den anderen schon sortierten Werten mischen */

dest = new struct sm[pr->sortmsize + 2];
end = mergesort(dest);

/* delete old list      */

delete sortmerge;
sortmerge = dest;

/*************************************************************/
/* fehlende Werte in presult besetzen                        */
/*************************************************************/

if ( end == dest) /* empty sort-array */
        {
        phase = END;
        return;
        }

/*****************************************************************/
/* Beim ersten Wert so tun als w"are er der gerade kleinste Wert */
/*****************************************************************/

if ( pr->xlevlim == -MAXDOUBLE)
        {
        while ( (end-1)->rvakt == (end - pr->nxvalue -1)->rvakt) pr->nxvalue++;
//      pr->xlevlim = (end-1)->rvakt;
//      echoresult( pr, nrv );
        }

/*************************************/
/* search new level                  */
/*************************************/

if ( (end - dest) <= presult->sortmsize )
        {                       /* neues xlevel */
        neurvakt = (end-1)->rvakt;
        }
else 
        {
        neurvakt = ( dest + presult->sortmsize)->rvakt;
        if ( neurvakt == pr->xlevlim
          || neurvakt == (end-1)->rvakt && pr->xlevlim == -MAXDOUBLE )
                neurvakt = ( end - pr->nxvalue - 1 )->rvakt;
        }

presult->xlevlim = neurvakt;
end->rvakt = neurvakt + 1.0; // ist jetzt immmer ungleich rvakt;

while(dest->rvakt > neurvakt)
        {
        if (dest->rvnach < neurvakt)
                presult->transcount++;
        dest++;
        }
sortmergeend = dest;

while (dest->rvakt == neurvakt)
        {
        if (dest->rvnach < neurvakt)
                presult->transcount++;
        presult->nxvalue++;
        dest++;
        }

presult->sortmsize = dest - sortmerge ;

/*************************************************************/
/* Sortierfeld Erneuern                                      */
/*************************************************************/

sortquickend = sortquick;
}

struct CNLRE::sm *CNLREG::mergesort(struct sm *dest)
{

register struct sm *source1 = sortquick;
register struct sm *end1 = sortquickend;
register struct sm *source2 = sortmerge;
register struct sm *end2 = sortmergeend;

if (source1 != end1 && source2 != end2)
        { /* keines der Felder leer */
        while (1)
                {       /* aus beiden Quellen mischen */
                if (source1->rvakt >= source2->rvakt)
                        {
                        *dest++ = *source1++ ;
                        if (source1 == end1) break ;
                        }
                else
                        {
                        *dest++ = *source2++ ;
                        if (source2 == end2) break ;
                        }
                }
        }


if (source1 == end1 )
        {                       /* source 1 empty */
        while(source2 < end2 )
                *dest++ = *source2++ ;
        }
else
        {                       /* source 2 empty */
        while(source1 < end1 )
                *dest++ = *source1++ ;
        }
return(dest);
}
void CNLREG::quicksort(struct sm *first,struct sm *last)
{
        register struct sm *left = first-1 ;
        register struct sm *right = last+1 ;
        register double ref = first->rvakt;
        register struct sm temp ;

        while (left < right)
                {
                while ((++left)->rvakt > ref);
                while ((--right)->rvakt < ref);
                if (left < right)
                        {
                        temp = *left;
                        *left = *right;
                        *right = temp;
                        }
                }
        left--;
        right++;
        if (first < left) quicksort(first, left) ;
        if (right < last) quicksort(right, last) ;
}
/***********************************************************************/
/*  die Funktion sortiert die Werte in das Ergebnisfeld ein.           */
/*  Das Ergebnisfeld ist differentiell abgelegt.                       */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

void CNLREG::verbesser(struct result *pfirst,struct result *pr,
                      double rvakt,double rvnach)
{

register struct result *start = pfirst;
register struct result *end = pr;
register struct result *presult;
register int step;

//printf("Verbesser: %f   %f   %f   %f   %f\n", pfirst->xlevlim, pr->xlevlim,
//      rvakt,rvnach);

while( (step = end - start) > 1)
        {
        presult = start + (step >> 1);
        if ( presult->xlevlim >= rvakt)
                {
                end = presult;
                }
        else
                {
                start = presult;
                }
        }

if (end->xlevlim == rvakt)
        {
        end->nxvalue++;
        }
else
        {
        end--;
        }
end->sortmsize++;

if (rvnach < end->xlevlim)
        {
        end->transcount++;
        start = pfirst;
        while( (step = end - start) > 1)
                {
                presult = start + (step >> 1);
                if ( presult->xlevlim > rvnach)
                        {
                        end = presult;
                        }
                else
                        {
                        start = presult;
                        }
                }
        start->transcount--;
        }
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNLREG
static CNClass CNLREG_desc("CNLREG", "$Revision: 0.27 $",
                           CNLREG::new_object);

// "Type" for type checking functions
CNClassDesc CN_LREG = &CNLREG_desc;
