//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLTimer.c,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLTimer --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLTimer.h"

CNSDLTimer::CNSDLTimer()
{
    list = NIL;
}



CNSDLSignal *CNSDLTimer::set(CNSimTime time, TimerType t_type,
			     CNDLList *save_l, 
                             CNEventBaseSched *sched, PId proc, int sy)
{
    reset(t_type, save_l, sched);  // set implies reset in SDL
    
    Timer *act = new Timer;
    act->t_name = t_type;
    act->t_next = list;
    act->t_id = 0;  // should be replaced by the real value (tell_ID)
    list = act;
    
    return new CNSDLSignal(t_type, time, proc, proc, sy);
}


void CNSDLTimer::reset(TimerType t_type, CNDLList *save_l, 
                       CNEventBaseSched *sched)
{
    if (active(t_type))
    {
        Timer *act, *th;
        for (act=list; act!=NIL; th=act, act=act->t_next)
        {
            if (act->t_name == t_type)
            {
                CNEvent *ev = sched->peek_event(act->t_id);
                if (ev) sched->delete_event(act->t_id);  // timer event isn't
                                                         // delivered yet
                else if(save_l) 
                {    // signal may be in save_list
                    CNDLObject *saved_sig = save_l->first();
                    while(saved_sig)
                    {
                        CNSDLSignal *sig = (CNSDLSignal*)saved_sig;
                        if (sig->type()==t_type)
                        {
                                // delete timer event from save list
                            save_l->delete_object(saved_sig);
                            break;
                        }
                        else saved_sig = save_l->next(saved_sig);
                    }
                }
                remove(t_type);
                break;
            }
        }            
    }
}
        

bool CNSDLTimer::active(TimerType t_type)
{
    bool timer_in_list = FALSE;
    Timer *act;
    for (act=list; act!=NIL; act=act->t_next)
        if (t_type==act->t_name)
        {
            timer_in_list = TRUE;
            break;
        }
    return timer_in_list;
}


void CNSDLTimer::remove(TimerType t_type)
{
    Timer *act, *th = list;
    
    for (act=list; act!=NIL; th=act, act=act->t_next)
    {
        if (act->t_name == t_type)
        {
            if (act==list) 
            {
                list = act->t_next;
                delete act;
            }
            else
            {
                th->t_next = act->t_next;
                delete act;
            }
            break;
        }
    }
}


void CNSDLTimer::tell_ID(CNEventID id)
{
    if(!list->t_id) list->t_id = id;
}


void CNSDLTimer::clear(CNDLList *save_l, CNEventBaseSched *sched)
{
    Timer *act;
    for (act=list; act!=NIL; act=act->t_next)
        reset(act->t_name, save_l, sched);
}

    
/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLTimer::print(ostream &strm) const
{
    strm << "CNSDLTimer" << endl;
}

// Debug output
void CNSDLTimer::dump(ostream &strm) const
{
    strm << "CNSDLTimer { $Revision: 0.27 $ ..." << endl;
    Timer *act = list;
    while (act != NIL) {
        strm << "Timer " << act->t_name << " Id=" << act->t_id << endl;
        act = act->t_next;
    }
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLTimer
static CNClass CNSDLTimer_desc("CNSDLTimer", "$Revision: 0.27 $",
			    CNSDLTimer::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLTIMER = &CNSDLTimer_desc;

