//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcess.c,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcess --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLProcess.h"


CNSDLProcess::CNSDLProcess(char *pname, CNSDLManager *SM, int typ)
{
    p_name = pname; stack = NIL;
    System = SM; p_type = typ;
    
    save_list = new CNDLList;
    p_timer = new CNSDLTimer;

    p_self = p_parent = p_offspring = p_sender = 0;

    handler = &CNSDLProcess::process;
    actual_state = 0; sub_state = 0;
}


CNSDLProcess::~CNSDLProcess()
{
    p_timer->clear(save_list, System->scheduler());
    delete p_timer;
    clear_savelist();
    delete save_list;
    stack_i *h;
    while( stack )
    {
        h = stack->stack_end;
        delete stack;
        stack = h;
    }
}


PMF CNSDLProcess::_global_pointer_to_actual_sdlsignalhandler_ = NIL;


char* CNSDLProcess::get_name() const
{
    return p_name;
}


// actual simulation time
CNSimTime CNSDLProcess::now()
{
    return System->now();
}


void CNSDLProcess::save(CNSDLSignal *sig)
{
    save_list->append( sig );
}


void CNSDLProcess::clear_savelist()
{
    CNDLObject *saved_sig = save_list->first();
    while (saved_sig)
    {
        saved_sig = save_list->delete_object(saved_sig);
    }
}




// procedure call
void CNSDLProcess::procedure(PMF fp, SignalType name)
{
    stack_i *h = stack;   // raise stack
    stack = new stack_i;
    stack->stack_end = h;
    
    stack->old_state = state();  // save current state (and more)
    stack->old_handler = handler;
    stack->helpval = sub_state;
    stack->old_signame = name;
    
    handler = fp;  // give control to procedure
    state(0);      // and set it to initial state
    return;
}


SignalType CNSDLProcess::from_procedure()
{
    handler = stack->old_handler;  // return control to caller
    state(stack->old_state);       // restore state (and more)
    sub_state = stack->helpval + 1;
    SignalType name = stack->old_signame;
    
    stack_i *h = stack->stack_end; // lower stack
    delete stack;
    stack = h;
    return name;
}

    
    

// process function must be defined in derived class
virtual int CNSDLProcess::process(int signal)
{
    fatal("CNSDLProcess ","no function process defined.");
    return 0;
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLProcess::print(ostream &strm) const
{
    strm << "CNSDLProcess" << " name=" << p_name << " state=" 
         << actual_state << endl;
    strm << "PId's: self=" << p_self
         << " parent=" << p_parent << " offspring=" << p_offspring 
         << " sender=" << p_sender << endl;
}

// Debug output
void CNSDLProcess::dump(ostream &strm) const
{
    strm << "CNSDLProcess { $Revision: 0.27 $ ..." << endl;
    strm << "name=" << p_name << " state=" << actual_state << " type=" 
         << p_type << endl;
    strm << "PId's: self=" << p_self
         << " parent=" << p_parent << " offspring=" << p_offspring 
         << " sender=" << p_sender << endl;
    strm << "save-list:" << endl;
    save_list->dump(strm);
    strm << "timer:" << endl; 
    p_timer->dump(strm);               
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLProcess
static CNClass CNSDLProcess_desc("CNSDLProcess", "$Revision: 0.27 $",
			    CNSDLProcess::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESS = &CNSDLProcess_desc;


