//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLChannel.h,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLChannel --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __CNSDLChannel_h
#define __CNSDLChannel_h

/*
   This class represents a SDL channel. Signals are delayed but may not
   overtake each other. The data belonging to the signal may be altered.
   Default delay is 0. The disturb function can be defined in a derived
   class.
*/

#include <CNCL/Object.h>		// Base class

#include <CNCL/SimTime.h>
#include <CNCL/Determ.h>
#include <CNCL/FiboG.h>

extern CNClassDesc CN_SDLCHANNEL;	// Class CNSDLChannel description

typedef int SignalType;

/*
 * The class CNSDLChannel
 */

class CNSDLChannel : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNSDLChannel(CNParam *param):last_arrival(0.), local_rng(false) {}
    	// CNParam constructor
    CNSDLChannel(CNRandom*);
    CNSDLChannel();  
    ~CNSDLChannel();
    
  public:	/***** Public interface **************************************/
    
    void set_channel_delay(CNRandom*);  
    CNRandom* get_channel_delay();
    
    double delay(double);
    virtual void disturb(const SignalType name, CNObject* data) {};
    
     
  private:	/***** Internal private members ******************************/
    CNRNG *base;
    CNRandom *rnd_delay;
    CNSimTime last_arrival;

    bool local_rng;
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SDLCHANNEL; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SDLCHANNEL ? TRUE : CNObject::is_a(desc); }
        
    static CNSDLChannel *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSDLChannel *)obj;
#   else
	return (CNSDLChannel *)( !obj || obj->is_a(CN_SDLCHANNEL)
	       ? obj : fatal_type(obj->class_desc(), CN_SDLCHANNEL) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSDLChannel(param) : new CNSDLChannel; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNSDLChannel &obj);
ostream &operator << (ostream &strm, const CNSDLChannel *obj);

#endif /**__CNSDLChannel_h**/
