//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLChannel.c,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLChannel --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include <CNCL/Class.h>

#include "SDLChannel.h"


CNSDLChannel::CNSDLChannel(CNRandom *rng):last_arrival(0.)
{
    if (rng)
    {
        rnd_delay = rng;
        local_rng = false;
    }
    else
    {
        base = new CNFiboG;
        rnd_delay = new CNDeterm(0, base);
        local_rng = true;
    }
}


CNSDLChannel::CNSDLChannel():last_arrival(0.)
{
    base = new CNFiboG;
    rnd_delay = new CNDeterm(0, base);
    local_rng = true;
}


CNSDLChannel::~CNSDLChannel()
{
    if (local_rng)
    {
        delete rnd_delay;
        delete base;
    }
}




// set/get channel delay
void CNSDLChannel::set_channel_delay(CNRandom *rng)
{
    rnd_delay = rng;
}


CNRandom *CNSDLChannel::get_channel_delay()
{
    return rnd_delay;
}




// random delay
double CNSDLChannel::delay(double now)
{
    CNSimTime arrival;
    while((arrival = now+rnd_delay->draw()) < last_arrival);
    
    return last_arrival = arrival;
}




/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLChannel::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void CNSDLChannel::dump(ostream &strm) const
{
    strm << "CNSDLChannel { $Revision: 0.27 $ ..." << endl
         << "last_arrival=" << last_arrival << "\trnd_delay=" 
         << rnd_delay << endl;
    strm << " }" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNSDLChannel &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNSDLChannel *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLChannel
static CNClass CNSDLChannel_desc("CNSDLChannel", "$Revision: 0.27 $",
			    CNSDLChannel::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLCHANNEL = &CNSDLChannel_desc;
