// -*- C++ -*-

/*
 * Test program for random number generators
 */

#include <string.h>

#include <CNCL/Moments.h>

#include <CNCL/RNG.h>

#include <CNCL/ACG.h>
#include <CNCL/FiboG.h>
#include <CNCL/FileG.h>
#include <CNCL/LCG.h>
#include <CNCL/MLCG.h>
#include <CNCL/TausG.h>


enum { NCNRNG = 10, NVAL = 100000 };


char buffer[128];



main()
{
    CNRNG *rng[NCNRNG];
    int i, j;
    
    rng[0] = new CNACG();
    rng[1] = new CNFiboG();
    rng[2] = new CNLCG();
    rng[3] = new CNMLCG();
    rng[4] = new CNTausG();
    rng[5] = NIL; // new CNFileG("/source/pub/puran2/puran2.noparity");
    rng[6] = NIL;
    
    for(i=0; rng[i]; i++)
    {
	{
	    strcpy(buffer, rng[i]->class_desc()->name());
	    strcat(buffer, " ");
	    strcat(buffer, rng[i]->class_desc()->version());
	    strcat(buffer, " --- as_long()");
	    
	    CNMoments stat(buffer);
	    
	    for(j=0; j<NVAL; j++)
		stat.put(rng[i]->as_long());
	    
	    cout << stat;
	}
	
	{
	    strcpy(buffer, rng[i]->class_desc()->name());
	    strcat(buffer, " ");
	    strcat(buffer, rng[i]->class_desc()->version());
	    strcat(buffer, " --- as_float()");
	    
	    CNMoments stat(buffer);
	    
	    for(j=0; j<NVAL; j++)
		stat.put(rng[i]->as_float());
	    
	    cout << stat;
	}
	
	{
	    strcpy(buffer, rng[i]->class_desc()->name());
	    strcat(buffer, " ");
	    strcat(buffer, rng[i]->class_desc()->version());
	    strcat(buffer, " --- as_double()");
	    
	    CNMoments stat(buffer);
	    
	    for(j=0; j<NVAL; j++)
		stat.put(rng[i]->as_double());
	    
	    cout << stat;
	}
    }
}
