//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: TextObject.c,v 0.27 1995/01/20 15:15:43 cncl-adm Exp cncl-adm $
 *
 * Class: TextObject --- replacement for GIST1 TextObject
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "TextObject.h"

TextObject::TextObject(World& w,
		       const char *objectname,
		       const char *color,
		       float x, float y, 
		       float width, float height,
		       double time) :
  ColorfulObject(w, objectname)
{
    lasttime = time;
    pos = new GISTCoordAttribute(this, "Position");
    col = new GISTTextAttribute(this, "Color");
    txt = new GISTTextAttribute(this, "Text");
    pic = new GISTPicture(this, "Image");
    pos->put(time, x, y);
    col->put(time, color);
    pic->set_color(col);
    pic->set_pos(pos);
    pic->text(txt, height, "courier");
};

void TextObject::change_look(const char *picname) {};

void TextObject::put_text(double time, const char *newtext) {
    txt->put(time, newtext);
    lasttime = time;
};


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void TextObject::print(ostream &strm) const
{
    GISTObject::print(strm);
    pos->print(strm);
    col->print(strm);
    txt->print(strm);
    pic->print(strm);
}

// Debug output
void TextObject::dump(ostream &strm) const
{
    strm << "TextObject { $Revision: 0.27 $" << endl;
    GISTObject::dump(strm);
    pos->dump(strm);
    col->dump(strm);
    txt->dump(strm);
    pic->dump(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class TextObject
static CNClass TextObject_desc("TextObject", "$Revision: 0.27 $",
			    TextObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_TEXTOBJECT = &TextObject_desc;
