//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DiagObject.c,v 0.27 1995/01/20 15:15:43 cncl-adm Exp cncl-adm $
 *
 * Class: DiagObject --- replacement for GIST1 DiagObject
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "DiagObject.h"


DiagObject::DiagObject(World& w,
		       const char *objectname,
		       const char *color,
		       unsigned diagsize,
		       float x, float y, 
		       float width, float height,
		       double time,
		       Displaymode mode) :
  ColorfulObject(w, objectname)
{
    lasttime = time;
    size = diagsize;
    val = new GISTCoordArrayAttribute(this, "Values", size);
    if (mode==bars) {
	diag = new GISTDiagram(this,objectname,val,x,y,GISTDiagram::bars,width,height);
    } else {
	diag = new GISTDiagram(this,objectname,val,x,y,GISTDiagram::curve,width,height);
    };
};

void DiagObject::move(float x, float y, double time) {};

void DiagObject::change_look(const char *picname) {};

void DiagObject::change_color(const char *color) {};

void DiagObject::change_color(float red, float green, float blue) {};

void DiagObject::put_diag(double time, const CNCoord newdiag[]) {
    lasttime = time;
    val->put(time, newdiag);
};

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void DiagObject::print(ostream &strm) const
{
    GISTObject::print(strm);
    val->print(strm);
    diag->print(strm);
}

// Debug output
void DiagObject::dump(ostream &strm) const
{
    strm << "DiagObject { $Revision: 0.27 $" << endl;
    GISTObject::dump(strm);
    val->dump(strm);
    diag->dump(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class DiagObject
static CNClass DiagObject_desc("DiagObject", "$Revision: 0.27 $",
			       DiagObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_DIAGOBJECT = &DiagObject_desc;
