//*BHEADER* :ts=8  -*- C++ -*-
/******************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDPushButton.c,v 0.27 1995/01/20 15:15:05 cncl-adm Exp cncl-adm $
 *
 * Class: EZDPushButton --- Interface to ezd push-button
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDPushButton.h"



/*
 * Initialize push button
 */
void EZDPushButton::initialize()
{
    out() << "(push-button " << name() << " "
	  << x << " " << y << " " << w << " " << h << " "
	  << "\"" << text << "\" " << action << ")" << endl;
    out().flush();
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDPushButton::print(ostream &strm) const
{
    strm << "x=" << x << " y=" << y << " w=" << w << " h=" << h <<endl;
    strm << " text=" << text << endl;
    strm << " action=" << action << endl;
}

// Debug output
void EZDPushButton::dump(ostream &strm) const
{
    strm << "EZDPushButton { $Revision: 0.27 $" << endl;
    print(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDPushButton
static CNClass EZDPushButton_desc("EZDPushButton", "$Revision: 0.27 $",
				  EZDPushButton::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDPUSHBUTTON = &EZDPushButton_desc;






