//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDObject.c,v 0.27 1995/01/20 15:15:05 cncl-adm Exp cncl-adm $
 *
 * Class: EZDObject --- Interface to ezd object
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDObject.h"



/*
 * Start/end ezd object
 */
void EZDObject::start()
{
    out() << "(object " << name() << endl;
}


void EZDObject::end()
{
    out() << ")" << endl;
    out().flush();
}

void EZDObject::delete_obj(const CNString &draw_name) 
{
    start();
    end();
    out() << "(set-attributes " << draw_name << " " << name() 
	  << " (delete-object))" << endl;
    out().flush();
}

void EZDObject::start(const CNString &object_name)
{
    out() << "(object " << object_name << endl;
}


/*
 * Drawing primitives
 */
void EZDObject::point(int x, int y, const CNString &col)
{
    EZD::draw_point(lastxb=(x+ox), lastyb=(y+oy), col);
}


void EZDObject::line(int x1, int y1, int x2, int y2,
	       const CNString &col, int width)
{
    EZD::draw_line(lastxb=(x1+ox), lastyb=(y1+oy), lastxe=(x2+ox), 
		   lastye=(y2+oy), col, width);
}


void EZDObject::arc(int x, int y, int w, int h, int a1, int a2,
			 const CNString &col, int width)
{
    EZD::draw_arc(lastxb=(x+ox), lastyb=(y+oy), w, h, a1, a2, col, width);
}


void EZDObject::fill_arc(int x, int y, int w, int h, int a1, int a2,
			      const CNString &col)
{
    EZD::draw_fill_arc(lastxb=(x+ox), lastyb=(y+oy), w, h, a1, a2, col);
}

void EZDObject::pie_arc(int x, int y, int w, int h, int a1, int a2,
			      const CNString &col)
{
    EZD::draw_pie_arc(lastxb=(x+ox), lastyb=(y+oy), w, h, a1, a2, col);
}

void EZDObject::rectangle(int x, int y, int w, int h,
		    const CNString &col, int width)
{
    EZD::draw_rectangle(lastxb=(x+ox), lastyb=(y+oy), w, h, col, width);
}


void EZDObject::fill_rectangle(int x, int y, int w, int h, const CNString &col)
{
    EZD::draw_fill_rectangle(lastxb=(x+ox), lastyb=(y+oy), w, h, col);
}


void EZDObject::text(int x, int y, const CNString &text,
		     const CNString &col, const CNString &font)
{
    EZD::draw_text(lastxb=(x+ox), lastyb=(y+oy), text, col, font);
}


void EZDObject::text(int x, int y, int w, int h, const CNString align,
		     const CNString &text, const CNString &col,
		     const CNString &font)
{
    EZD::draw_text(lastxb=(x+ox), lastyb=(y+oy), w, h, align, text, col, font);
}


void EZDObject::bitmap(int x, int y, int w, int h, const CNString &filename,
		      const CNString &color1, const CNString &color2)
{
    EZD::draw_bitmap(lastxb=(x+ox), lastyb=(y+oy), w, h, filename, color1, 
		     color2);
}

void EZDObject::bitmap(int x, int y, const CNString &filename,
		      const CNString &color1, const CNString &color2)
{
    EZD::draw_bitmap(lastxb=(x+ox), lastyb=(y+oy), filename, color1, color2);
}


/*
 * Default redraw(): issue error message
 */
virtual void EZDObject::redraw()
{
    error(NIL, "EZDObject: ", "redraw() not implemented");
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDObject::print(ostream &strm) const
{
    strm << "EZDObject " << name() << " : (" << ox << "," << oy << ")" << endl;
}

// Debug output
void EZDObject::dump(ostream &strm) const
{
    strm << "EZDObject { $Revision: 0.27 $ " << name() << " (" << ox
	<< "," << oy << ")" << " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDObject
static CNClass EZDObject_desc("EZDObject", "$Revision: 0.27 $",
			      EZDObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDOBJECT = &EZDObject_desc;






