//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Template.c,v 0.3 1993/01/05 10:17:15 mj Exp mj $
 *
 * CNClass: Test --- Test class for tDL test
 *
 * $Log: Template.c,v $
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Test.h"



/***** Default I/O member function for CNCL classes **************************/

// ***** Change this for your class *****

// CNNormal output
void Test::print(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "n=" << n << endl;
}

// Debug output
void Test::dump(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "Test { "
	 << "n=" << n
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class Test
static CNClass Test_desc("Test", "$Revision: 0.3 $", Test::new_object);

// "Type" for type checking functions
CNClassDesc CN_TEST = &Test_desc;



/***** Safe type casts *******************************************************/

Test *Test::cast_from_object(CNObject *obj)
{
    if(!test_flag(type_check))
	return (Test *)obj;
    if(obj->is_a(CN_TEST))
	return (Test *)obj;
    else
    {
	fatal(NIL, "Invalid type cast: ", obj->class_desc()->name(),
	      " -> Test");
	return NIL;
    }
}



/***** CNObject creation *******************************************************/

CNObject *Test::new_object(CNParam *param)
{
    return param ? new Test(param) : new Test;
}
