//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: CNQueueRandom --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "QueueRandom.h"


CNQueueRandom::CNQueueRandom()
{
    rng = new CNFiboG;
    rand.generator(rng);
    internal_rng = TRUE;
    n = 0;
}



CNQueueRandom::~CNQueueRandom()
{
    if (internal_rng) delete rng;
}



bool CNQueueRandom::empty() const
{
    return n == 0;
}


bool CNQueueRandom::full() const
{
    return FALSE;
}


int CNQueueRandom::length() const
{
    return n;
}


void CNQueueRandom::put(CNObject *obj)
{
    list.append(obj);
    n++;
}


CNObject *CNQueueRandom::get()
{
    CNDLObject *pos;
    CNObject *obj;
    int no = rand.as_int(1, n);

    pos = list.first();
    for (int i=1; i<no; i++) pos = pos->next();

    if(pos)
    {
	obj = pos->object();
	list.delete_object(pos);
	n--;
    }
    else
	obj = NIL;
    
    return obj;
}


void CNQueueRandom::delete_all()
{
    list.delete_all();
    n = 0;
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNQueueRandom::print(ostream &strm) const
{
    strm << "length=" << n << endl;
    list.print(strm);
}

// Debug output
void CNQueueRandom::dump(ostream &strm) const
{
    strm << "CNQueueRandom { $Revision$ ..." << endl
         << "length=" << n << endl;
    list.dump(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNQueueRandom
static CNClass CNQueueRandom_desc("CNQueueRandom", "$Revision$",
			    CNQueueRandom::new_object);

// "Type" for type checking functions
CNClassDesc CN_QUEUERANDOM = &CNQueueRandom_desc;
