//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLObject.c,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDLObject --- Double linked object for CNDLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "DLObject.h"



/***** Default I/O member function for CNCL classes **************************/

// ***** Change this for your class *****

// CNNormal output
void CNDLObject::print(ostream &strm) const
{
    strm <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 << " prev=" << hex << (unsigned long)pprev << dec << endl
	 <<  "obj="  << pobj;
}

// Debug output
void CNDLObject::dump(ostream &strm) const
{
    strm << "CNDLObject { "
	 << "$Revision: 0.27 $" << endl
	 <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 << " prev=" << hex << (unsigned long)pprev
	 << " obj="  << hex << (unsigned long)pobj << dec << endl;
    if(pobj)
	pobj->dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNDLObject
static CNClass CNDLObject_desc("CNDLObject", "$Revision: 0.27 $",
			   CNDLObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_DLOBJECT = &CNDLObject_desc;






