// *BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PString.h,v 0.27 1995/01/20 15:14:52 cncl-adm Exp cncl-adm $
 *
 * Class: CNPString --- class persistent CNString
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNPString_h
#define __CNPString_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/String.h>		// Base class
#include <CNCL/PObjectID.h>             // Base class

#include <CNCL/PIO.h>		// Methodes for persistency


extern CNClassDesc CN_PSTRING;	// Class CNPString description


/*
 * The class CNPString
 */

class CNPString : public CNString, public CNPObjectID
{
  public:	/***** Constructors ******************************************/ 
    CNPString(CNPstream&);				//read_from constructor

    CNPString()                        : CNString(), CNPObjectID() {}
    CNPString(CNParam *param)          : CNString(param), CNPObjectID(){}
    CNPString(int extra)               : CNString(extra), CNPObjectID(){}
    CNPString(const char *s)           : CNPObjectID(), CNString(s){}
    CNPString(const char *s, int l)    : CNString(s, l), CNPObjectID(){}
    CNPString(const CNPString &s)      : CNString(s), CNPObjectID(){}
    CNPString(const CNPString &s, int l): CNString(s, l), CNPObjectID(){}

    void operator=(const CNString &s) { CNString::operator=(s); }
    void operator=(const char *s)     { CNString::operator=(s); }
    void operator=(char c)            { CNString::operator=(c); }
    

  public:	/***** Public interface for persistent IO ********************/
    virtual int store_on(CNPstream& s) 
               {return CNPIO::store_object(s, *this);}
    int store_on(CNPstream& s, bool no_ptr_check)
              {return CNPIO::store_object(s, *this, no_ptr_check);} 
    virtual int storer(CNPstream&);
    static CNObject* object_read_from(CNPstream& s)
               {return CNPIO::read_object(s);}
    static CNPString* read_from(CNPstream& s)
               {return CNPString::cast_from_object(CNPIO::read_object(s));}
    static CNPString* reader(CNPstream& s) {return new CNPString(s);}
    
    CNPID object_id() { return CNPObjectID::object_id(); }
    

  private:	/***** Internal private members ******************************/
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PSTRING; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PSTRING ? TRUE : CNString::is_a(desc); }
        
    static CNPString *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPString *)obj;
#   else
	return (CNPString *)( !obj || obj->is_a(CN_PSTRING)
	       ? obj : fatal_type(obj->class_desc(), CN_PSTRING) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNPString(param) : new CNPString; }
    
};

#endif /**__CNPString_h**/








