//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLTimer.h,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLTimer --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSDLTimer_h
#define __CNSDLTimer_h

/*
   SDLTimer manages the timer events for a SDL process. It seems to be hardly
   useable by normal users but will do a good job in combination with SDLMa-
   nager. It stores the used timer names and the Event_Id in an internal list
   and provides functions to manipulate the timers.
*/

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/SimTime.h>
#include <CNCL/DLList.h>
#include <CNCL/EventScheduler.h>
#include <CNCL/Event.h>

#include <CNCL/SDLSignal.h>

extern CNClassDesc CN_SDLTIMER;	// Class CNSDLTimer description


typedef int TimerType;
typedef int PId;


/*
 * The class CNSDLTimer
 */

class CNSDLTimer : public CNObject
{
  public:
    CNSDLSignal *set(CNSimTime, TimerType, CNDLList*, 
                     CNEventBaseSched*, PId, int);         // set timer
    void reset(TimerType, CNDLList*, CNEventBaseSched*);   // reset timer
    bool active(TimerType);
    void remove(TimerType);
    
    void tell_ID(CNEventID);  
    
    void clear(CNDLList*, CNEventBaseSched*);  // reset all timers    
    
    // Private members
  private:
    struct Timer {        // list of active timers
        TimerType t_name;
        CNEventID t_id;
        Timer *t_next;
    } *list;
    
        
    /***** Constructors ******************************************************/
  public:
    CNSDLTimer(); 				// Default constructor
    CNSDLTimer(CNParam *param) {}			// CNParam constructor

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SDLTIMER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SDLTIMER ? TRUE : CNObject::is_a(desc);
    };
        
    static CNSDLTimer *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNSDLTimer *)obj;
#   else
        return (CNSDLTimer *)( !obj || obj->is_a(CN_SDLTIMER)
               ? obj : fatal_type(obj->class_desc(), CN_SDLTIMER) );
#   endif
    }
      
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL)
    { return param ? new CNSDLTimer(param) : new CNSDLTimer; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNSDLTimer_h**/
