//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Rice.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNRice --- CNRice distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Rice_h
#define __Rice_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Normal.h>		// Base class

extern CNClassDesc CN_RICE;	// CNClass CNRice description



/*
 * The class CNRice
 */

class CNRice : public CNNormal
{
public:
    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNRice(); 		          		// Default constructor
    CNRice(CNParam *param); 			// CNParam constructor
    CNRice(double mean1, double variance, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_RICE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_RICE ? TRUE : CNNormal::is_a(desc);
    };
        
    static CNRice *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNRice *)obj;
#   else
	return (CNRice *)( !obj || obj->is_a(CN_RICE)
	       ? obj : fatal_type(obj->class_desc(), CN_RICE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNRice(param) : new CNRice; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNRice::CNRice(double mean1, double variance, CNRNG *gen)
    : CNNormal(mean1, variance, gen)
{}


inline CNRice::CNRice()
    : CNNormal(NIL)
{}

inline CNRice::CNRice(CNParam *param)
    : CNNormal(NIL)
{}

#endif /**__Rice_h**/
