//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventBaseSched.h,v 0.27 1995/01/20 15:14:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNEventBaseSched --- Abstract scheduler base class
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNEventBaseSched_h
#define __CNEventBaseSched_h


#include <CNCL/Object.h>		// Base class
#include <CNCL/Event.h>
#include <CNCL/EventHandler.h>
#include <CNCL/Statistics.h>


extern CNClassDesc CN_EVENTBASESCHED;	// Class CNEventBaseSched description

class CNEventIterator;


/*
 * The class CNEventBaseSched
 */

class CNEventBaseSched : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNEventBaseSched()          : simtime(0), stop_flag(FALSE), stat(NIL) {}
    CNEventBaseSched(CNParam *) : simtime(0), stop_flag(FALSE), stat(NIL) {}

  public:	/***** Public interface **************************************/
    virtual void send_event(CNEvent *ev) = 0;		// Send event
    virtual void add_event(CNEvent *ev) = 0;		// Send event
    virtual void delete_event(CNEventID id) = 0;	// Delete event
    virtual void delete_events(CNEventHandler*) = 0;	// Delete events for EH
    virtual CNEvent *peek_event() = 0;			// Peek next event
    virtual CNEvent *peek_event(CNEventID id) = 0;	// Peek event with id
  
    virtual void start() = 0;				// Start scheduler
    virtual void start(CNEvent *ev) = 0;		// Start scheduler

    virtual void stop() = 0;				// Stop scheduler

    virtual CNEventIterator *create_iterator() = 0;     // create event iterator
    		
    CNSimTime time() { return simtime; }		// Return simul. time

    CNStatistics *statistics() const           { return stat; };
    void          statistics(CNStatistics *st) { stat = st;   };
    

  protected:	/***** Protected stuff for event handler implementation ******/
    CNSimTime simtime;			// Simulation time
    bool stop_flag;			// Flag set by stop()

    CNStatistics *stat;			// Optional sched statistics
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTBASESCHED; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTBASESCHED ? TRUE : CNObject::is_a(desc); }
        
    static CNEventBaseSched *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventBaseSched *)obj;
#   else
	return (CNEventBaseSched *)( !obj || obj->is_a(CN_EVENTBASESCHED)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTBASESCHED) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};

#endif /**__CNEventBaseSched_h**/
